/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.Auth;
import digital.toke.HousekeepingConfig;
import digital.toke.RenewalType;
import digital.toke.Token;
import digital.toke.TokenManager;
import digital.toke.TokenRenewal;
import digital.toke.accessor.SealStatus;
import digital.toke.accessor.Toke;
import digital.toke.exception.ConfigureException;
import digital.toke.exception.LoginFailedException;
import digital.toke.exception.ReadException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HousekeepingBase
implements Runnable {
    private static final Logger logger = LogManager.getLogger(HousekeepingBase.class);
    protected TokenManager tokenManager;
    protected HousekeepingConfig config;

    public HousekeepingBase(TokenManager parent) {
        this.tokenManager = parent;
        HousekeepingConfig hc = this.tokenManager.getAuth().config.getHousekeepingConfig();
        this.config = hc == null ? HousekeepingConfig.defaultInstance() : hc;
    }

    public HousekeepingBase(HousekeepingConfig config, TokenManager parent) {
        this.config = config;
        this.tokenManager = parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unseal() {
        logger.debug("entering unseal");
        Auth auth = this.tokenManager.getAuth();
        try {
            Toke response = auth.checkSealStatus();
            SealStatus vaultInstance = new SealStatus(response);
            if (!vaultInstance.isSealed()) {
                logger.info("Vault instance appears to be unsealed  - good.");
                return;
            }
            if (this.config.unseal && this.config.unsealKeys != null && this.config.unsealKeys.size() > 0) {
                try {
                    response = auth.unseal(this.config.getUnsealKeys(), false, false);
                }
                catch (ConfigureException e) {
                    logger.error((Object)e);
                    response = null;
                }
                if (response == null) {
                    logger.error("Bad response?");
                    return;
                }
                vaultInstance = new SealStatus(response);
                if (vaultInstance.isSealed()) {
                    logger.error("expected to unseal, but failed..." + vaultInstance.json().toString());
                    return;
                }
                logger.info("Unsealed successfully..." + vaultInstance.json().toString());
                return;
            }
            logger.info("Vault sealed, but conditions not met in config to attempt unseal");
            return;
        }
        catch (ReadException e1) {
            logger.error((Object)e1);
            return;
        }
        catch (NullPointerException z) {
            z.printStackTrace();
            logger.error((Object)z);
        }
    }

    protected void loadCachedTokens() {
    }

    protected void login() {
        Auth auth = this.tokenManager.getAuth();
        Set<Token> tokens = this.tokenManager.getManagedTokens();
        if (tokens.size() == 0) {
            logger.info("Zero tokens found, trying to login to get one...");
            Token token = null;
            try {
                token = auth.login();
                this.tokenManager.fireLoginEvent(token);
            }
            catch (LoginFailedException e) {
                logger.error((Object)e);
                return;
            }
            try {
                token = auth.lookupSelf(token);
                logger.debug("updated token with lookup data " + token.lookupData.toString());
                tokens.add(token);
                this.tokenManager.fireLoginEvent(token);
                return;
            }
            catch (ReadException e) {
                logger.error("Does this user have permission to read auth/token/lookup-self?", (Throwable)e);
                return;
            }
        }
    }

    public List<TokenRenewal> renew() {
        ArrayList<TokenRenewal> renewals = new ArrayList<TokenRenewal>();
        Set<Token> tokens = this.tokenManager.getManagedTokens();
        if (tokens.size() == 0) {
            return renewals;
        }
        Auth auth = this.tokenManager.getAuth();
        for (Token oldToken : tokens) {
            if (oldToken.isPeriodic()) {
                try {
                    Token newToken = auth.renewPeriodic(oldToken);
                    renewals.add(new TokenRenewal(RenewalType.PERIODIC, oldToken, newToken));
                }
                catch (Exception x) {
                    logger.info("Renew Periodic has failed, will try to reauthenticate and get a new token.", (Throwable)x);
                    try {
                        Token newToken = auth.login();
                        renewals.add(new TokenRenewal(RenewalType.LOGIN, oldToken, newToken));
                    }
                    catch (LoginFailedException e) {
                        logger.error((Object)e);
                        logger.error("giving up here...");
                    }
                }
                continue;
            }
            if (oldToken.isRenewable()) {
                logger.debug("token is renewable...");
                ZonedDateTime zdt = oldToken.expireTime();
                if (zdt == null) continue;
                Instant instant = zdt.toInstant();
                long count = Instant.now().until(instant, ChronoUnit.SECONDS);
                logger.info("Token with accessor " + oldToken.accessor() + " will expire in " + count + " seconds.");
                if (this.config.renew) {
                    logger.debug(String.format("Checking renew... min_ttl: %d, count: %d", this.config.min_ttl, count));
                    if (this.config.min_ttl <= count) continue;
                    logger.debug("OK, looks like should renew now");
                    try {
                        Token newToken = auth.renewSelf(oldToken);
                        renewals.add(new TokenRenewal(RenewalType.SELF, oldToken, newToken));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.info("Renew of non-periodic token has failed, will try to reauthenticate and get a new token.", (Throwable)e);
                        try {
                            Token newToken = auth.login();
                            renewals.add(new TokenRenewal(RenewalType.LOGIN, oldToken, newToken));
                        }
                        catch (LoginFailedException z) {
                            logger.error((Object)z);
                            logger.error("giving up here...");
                        }
                    }
                    continue;
                }
                logger.debug("Not yet in range to renew.");
                continue;
            }
            logger.debug("token is not renewable, so doing nothing...");
        }
        return renewals;
    }
}

