/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.HousekeepingBase;
import digital.toke.TokenManager;
import digital.toke.TokenRenewal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultHousekeepingImpl
extends HousekeepingBase {
    private static final Logger logger = LogManager.getLogger(DefaultHousekeepingImpl.class);

    public DefaultHousekeepingImpl(TokenManager parent) {
        super(parent);
    }

    @Override
    public void run() {
        logger.debug("Starting housekeeping run...");
        if (this.config.testReachable && !this.tokenManager.getAuth().hostIsReachable()) {
            logger.error("Host not reachable...bailing out of housekeeping.");
            return;
        }
        if (this.config.pingHost && !this.tokenManager.getAuth().pingHost()) {
            logger.error("Socket probe failed...bailing out of housekeeping.");
            return;
        }
        this.unseal();
        this.loadCachedTokens();
        this.login();
        List<TokenRenewal> renewals = this.renew();
        this.tokenManager.updateManagedSet(renewals);
        logger.debug("Completed housekeeping run...");
    }
}

