/*
 * Decompiled with CFR 0.152.
 */
package digital.toke;

import digital.toke.CreateTokenParameters;
import digital.toke.Networking;
import digital.toke.TokeDriverConfig;
import digital.toke.Token;
import digital.toke.accessor.Toke;
import digital.toke.exception.ConfigureException;
import digital.toke.exception.LoginFailedException;
import digital.toke.exception.ReadException;
import digital.toke.exception.WriteException;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class Auth {
    private static final Logger logger = LogManager.getLogger(Auth.class);
    TokeDriverConfig config;
    Networking client;

    public Auth(TokeDriverConfig config, Networking client) {
        this.config = config;
        this.client = client;
        logger.info("Auth instance " + this.hashCode() + " configured");
    }

    public void logoff(Token token) {
    }

    public void logoffSelf() {
    }

    public boolean pingHost() {
        return this.client.pingHost(this.config.host, this.config.port, 200);
    }

    public boolean hostIsReachable() {
        return this.client.checkIsReachable(this.config.host);
    }

    public Token renewSelf(Token token) throws WriteException, ReadException {
        String url = this.config.authTokenRenewSelf();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("increment", (Object)"1h");
        logger.debug(json.toString(4));
        Toke toke = null;
        try {
            toke = this.client.post(url, json.toString());
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        if (!toke.successful) {
            throw new WriteException("Failed to renew token with accessor " + token.accessor());
        }
        Token newToken = new Token(new JSONObject(toke.response), toke.successful);
        return this.lookupSelf(newToken);
    }

    public Token renewPeriodic(Token token) throws WriteException, ReadException {
        String url = this.config.authTokenRenew();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("token", (Object)token.clientToken());
        logger.debug(json.toString(4));
        Toke toke = null;
        try {
            toke = this.client.post(url, json.toString());
        }
        catch (IOException e) {
            throw new WriteException(e);
        }
        if (!toke.successful) {
            throw new WriteException("Failed to renew token with accessor " + token.accessor());
        }
        Token newToken = new Token(new JSONObject(toke.response), toke.successful);
        return this.lookupSelf(newToken);
    }

    public Toke checkSealStatus() throws ReadException {
        String url = this.config.baseURL().append("/sys/seal-status").toString();
        try {
            return this.client.get(url, false);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
    }

    public Toke unseal(List<String> keys, boolean reset, boolean migrate) throws ConfigureException {
        Toke toke = null;
        int count = 1;
        for (String key : keys) {
            logger.debug("sending unseal key " + count);
            toke = this.unseal(key, reset, migrate);
            ++count;
        }
        return toke;
    }

    public Toke unseal(String key, boolean reset, boolean migrate) throws ConfigureException {
        String url = this.config.baseURL().append("/sys/unseal").toString();
        logger.debug("Using: " + url);
        JSONObject json = new JSONObject().put("key", (Object)key).put("reset", reset).put("migrate", migrate);
        try {
            Toke response = this.client.put(url, json.toString(), false);
            if (response.code != 200) {
                throw new ConfigureException(response.toString());
            }
            return response;
        }
        catch (IOException e) {
            throw new ConfigureException(e);
        }
    }

    Token loginLDAP() throws LoginFailedException {
        String url = this.config.authLdapLogin();
        JSONObject json = new JSONObject();
        json.put("password", (Object)this.config.password);
        return this.httpLogin(url, json);
    }

    Token loginAppRole() throws LoginFailedException {
        String url = this.config.authAppRoleLogin();
        JSONObject json = new JSONObject();
        json.put("role_id", (Object)this.config.roleId);
        json.put("secret_id", (Object)this.config.secretId);
        return this.httpLogin(url, json);
    }

    Token loginUserPass() throws LoginFailedException {
        logger.debug("in loginUserPass");
        String url = this.config.authUserPassLogin();
        JSONObject json = new JSONObject();
        json.put("password", (Object)this.config.password);
        return this.httpLogin(url, json);
    }

    Token loginToken() throws LoginFailedException {
        String url = this.config.authTokenLogin();
        JSONObject json = new JSONObject();
        json.put("renewable", this.config.renewable);
        Toke result = null;
        try {
            result = this.client.loginToken(url, json.toString(), this.config.findToken());
        }
        catch (IOException e) {
            throw new LoginFailedException(e);
        }
        return new Token(new JSONObject(result.response), result.successful);
    }

    Token loginToken(CreateTokenParameters params) throws LoginFailedException {
        String url = this.config.authTokenLogin();
        JSONObject json = new JSONObject();
        json.put("renewable", this.config.renewable);
        Toke result = null;
        try {
            result = this.client.loginToken(url, json.toString(), this.config.findToken());
        }
        catch (IOException e) {
            throw new LoginFailedException(e);
        }
        return new Token(new JSONObject(result.response), result.successful);
    }

    private Token httpLogin(String url, JSONObject json) throws LoginFailedException {
        logger.debug("in httpLogin");
        Toke result = null;
        try {
            result = this.client.login(url, json.toString());
            logger.debug("got result: " + result);
        }
        catch (IOException e) {
            throw new LoginFailedException(e);
        }
        return new Token(new JSONObject(result.response), result.successful);
    }

    public Token login() throws LoginFailedException {
        Token t = null;
        switch (this.config.authType) {
            case LDAP: {
                t = this.loginLDAP();
                break;
            }
            case APPROLE: {
                t = this.loginAppRole();
                break;
            }
            case USERPASS: {
                t = this.loginUserPass();
                break;
            }
            case TOKEN: {
                t = this.loginToken();
                break;
            }
        }
        return t;
    }

    public Token lookupSelf(Token t) throws ReadException {
        String url = this.config.authTokenLookupSelf();
        logger.debug("using url = " + url);
        Toke toke = null;
        try {
            toke = this.client.get(url);
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        if (toke.successful) {
            if (toke.response == null || toke.response.contains("errors")) {
                throw new ReadException("Errors on token lookup: " + toke.response);
            }
            return new Token(t.getJson(), t.fromSuccessfulLoginRequest, new JSONObject(toke.response));
        }
        throw new ReadException("Failed to perform lookup: " + toke.toString());
    }

    public Token lookup(Token t) throws ReadException {
        String url = this.config.authTokenLookup();
        logger.debug("using url = " + url);
        JSONObject json = new JSONObject();
        json.put("token", (Object)t.clientToken());
        Toke toke = null;
        try {
            toke = this.client.post(url, json.toString());
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        if (toke.successful) {
            if (toke.response == null || toke.response.contains("errors")) {
                throw new ReadException("Errors on token lookup: " + toke.response);
            }
            return new Token(t.getJson(), t.fromSuccessfulLoginRequest, new JSONObject(toke.response));
        }
        throw new ReadException("Failed to perform lookup: " + toke.toString());
    }
}

