/*
 * Decompiled with CFR 0.152.
 */
package digital.toke.azc;

import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.CommonRestResponse;
import com.microsoft.azure.storage.blob.ContainerURL;
import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.azure.storage.blob.ListBlobsOptions;
import com.microsoft.azure.storage.blob.PipelineOptions;
import com.microsoft.azure.storage.blob.ServiceURL;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.TransferManager;
import com.microsoft.azure.storage.blob.models.BlobItem;
import com.microsoft.azure.storage.blob.models.ContainerListBlobFlatSegmentResponse;
import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpClientConfiguration;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.HttpPipelineLogger;
import com.microsoft.rest.v2.http.Slf4jLogger;
import com.microsoft.rest.v2.util.FlowableUtil;
import digital.toke.azc.CmdLineParser;
import digital.toke.azc.Item;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger slf4jLogger = LoggerFactory.getLogger(Main.class);
    private static boolean silent = false;
    private static boolean useProxy = false;
    private static List<Item> blobList = new ArrayList<Item>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            Main.help();
            return;
        }
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option<Boolean> helpOption = parser.addBooleanOption('h', "help");
        CmdLineParser.Option<Boolean> silentOption = parser.addBooleanOption('s', "silent");
        CmdLineParser.Option<String> configFileOption = parser.addStringOption('c', "config");
        CmdLineParser.Option<String> destOption = parser.addStringOption('d', "dest");
        CmdLineParser.Option<String> verbOption = parser.addStringOption('v', "verb");
        CmdLineParser.Option<String> fileOption = parser.addStringOption('f', "file");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            e.printStackTrace();
            return;
        }
        boolean needsHelp = parser.getOptionValue(helpOption, Boolean.FALSE);
        if (needsHelp) {
            Main.help();
            return;
        }
        silent = parser.getOptionValue(silentOption, Boolean.FALSE);
        String configPath = parser.getOptionValue(configFileOption, "./azc.properties");
        InputStream in = null;
        Properties props = new Properties();
        try {
            File azcConfig = new File(configPath);
            in = azcConfig.exists() ? new FileInputStream(configPath) : Thread.currentThread().getClass().getResourceAsStream("/azc.properties");
            props.load(in);
            useProxy = Boolean.valueOf(props.getProperty("USE_PROXY", "false"));
            ContainerURL containerURL = null;
            try {
                containerURL = Main.setup(props);
                if (containerURL == null) {
                    throw new RuntimeException("ContainerURL was null, cannot proceed");
                }
            }
            catch (Exception x) {
                if (!silent) throw x;
                System.exit(1);
            }
            Collection<String> files = parser.getOptionValues(fileOption);
            Path currentRelativePath = Paths.get("", new String[0]);
            String defaultPath = currentRelativePath.toAbsolutePath().toString();
            String destinationPath = parser.getOptionValue(destOption, defaultPath);
            String verb = parser.getOptionValue(verbOption, "");
            if ("".equals(verb)) {
                verb = "list";
            }
            switch (verb) {
                case "list": {
                    Main.list(containerURL);
                    return;
                }
                case "send": {
                    Main.send(containerURL, files);
                    return;
                }
                case "get": {
                    Main.get(containerURL, new File(destinationPath), files);
                    return;
                }
                case "getAll": {
                    Main.getAll(containerURL, new File(destinationPath));
                    return;
                }
            }
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static ContainerURL setup(Properties props) {
        ContainerURL containerURL = null;
        String accountName = System.getenv("AZURE_STORAGE_ACCOUNT");
        String accountKey = System.getenv("AZURE_STORAGE_ACCESS_KEY");
        String containerName = System.getenv("CONTAINER_NAME");
        if ((accountName == null || accountName.equals("")) && (accountName = props.getProperty("AZURE_STORAGE_ACCOUNT")) == null) {
            throw new RuntimeException("no accountName defined! Bailing out...");
        }
        if ((accountKey == null || accountKey.equals("")) && (accountKey = props.getProperty("AZURE_STORAGE_ACCESS_KEY")) == null) {
            throw new RuntimeException("no accountKey defined! Bailing out...");
        }
        if ((containerName == null || containerName.equals("")) && (containerName = props.getProperty("CONTAINER_NAME")) == null) {
            throw new RuntimeException("no containerName defined! Bailing out...");
        }
        try {
            SharedKeyCredentials creds = new SharedKeyCredentials(accountName, accountKey);
            HttpClient client = null;
            if (useProxy) {
                InetAddress addr = InetAddress.getByName(props.getProperty("HTTPS_PROXY"));
                int port = Integer.parseInt(props.getProperty("HTTPS_PROXY_PORT"));
                InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
                Main.info("Using PROXY. Settings: " + ((Object)sockaddr).toString());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, sockaddr);
                HttpClientConfiguration config = new HttpClientConfiguration(proxy);
                client = HttpClient.createDefault((HttpClientConfiguration)config);
            } else {
                client = HttpClient.createDefault();
            }
            PipelineOptions opts = null;
            if (silent) {
                opts = new PipelineOptions().withClient(client);
            } else {
                Slf4jLogger logger = new Slf4jLogger(slf4jLogger);
                opts = new PipelineOptions().withClient(client).withLogger((HttpPipelineLogger)logger);
            }
            HttpPipeline pipe = StorageURL.createPipeline((ICredentials)creds, (PipelineOptions)opts);
            ServiceURL serviceURL = new ServiceURL(new URL("https://" + accountName + ".blob.core.windows.net"), pipe);
            containerURL = serviceURL.createContainerURL(containerName);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return containerURL;
    }

    private static Observable<BlobItem> listBlobsLazy(ContainerURL containerURL, ListBlobsOptions listBlobsOptions) {
        return containerURL.listBlobsFlatSegment(null, listBlobsOptions, null).flatMapObservable(r -> Main.listContainersResultToContainerObservable(containerURL, listBlobsOptions, r));
    }

    private static Observable<BlobItem> listContainersResultToContainerObservable(ContainerURL containerURL, ListBlobsOptions listBlobsOptions, ContainerListBlobFlatSegmentResponse response) {
        Observable result = Observable.fromIterable((Iterable)response.body().segment().blobItems());
        if (response.body().nextMarker() != null) {
            result = result.concatWith((ObservableSource)containerURL.listBlobsFlatSegment(response.body().nextMarker(), listBlobsOptions, null).flatMapObservable(r -> Main.listContainersResultToContainerObservable(containerURL, listBlobsOptions, r)));
        }
        return result;
    }

    private static void list(ContainerURL containerURL) {
        blobList.clear();
        ListBlobsOptions options = new ListBlobsOptions();
        options.withMaxResults(Integer.valueOf(1000));
        Observable<BlobItem> items = Main.listBlobsLazy(containerURL, options);
        Iterable iter = items.blockingIterable();
        for (BlobItem item : iter) {
            Main.info(item.name());
            long length = item.properties().contentLength();
            String name = item.name();
            blobList.add(new Item(name, length));
        }
    }

    private static void getAll(ContainerURL containerURL, File destFolder) {
        Main.get(containerURL, destFolder);
    }

    private static void send(ContainerURL containerURL, Collection<String> filePaths) {
        for (String path : filePaths) {
            File file = new File(path);
            BlockBlobURL blobURL = containerURL.createBlockBlobURL(file.getName());
            try {
                Main.uploadFile(blobURL, file);
            }
            catch (IOException e) {
                try {
                    Main.error("Looks like we failed to upload " + file.getCanonicalPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    private static void uploadFile(BlockBlobURL blob, File sourceFile) throws IOException {
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(sourceFile.toPath(), new OpenOption[0]);
        CommonRestResponse response = (CommonRestResponse)TransferManager.uploadFileToBlockBlob((AsynchronousFileChannel)fileChannel, (BlockBlobURL)blob, (int)0x800000, (Integer)0x40000000, null).blockingGet();
        int status = response.response().statusCode();
        if (status == 201) {
            Main.info("Success!");
        }
        Main.info("Response code was: " + status + " for " + sourceFile.getName());
    }

    private static void get(ContainerURL containerURL, File destFolder, Collection<String> files) {
        Main.list(containerURL);
        for (String name : files) {
            File target = new File(destFolder, name);
            if (!target.exists()) {
                BlockBlobURL blobURL = containerURL.createBlockBlobURL(name);
                Main.getBlob(blobURL, target);
                continue;
            }
            Item matchingItem = null;
            for (Item item : blobList) {
                if (!item.name.equals(name)) continue;
                matchingItem = item;
                break;
            }
            if (matchingItem == null) {
                throw new RuntimeException("We should have matched an item here..." + name);
            }
            if (target.length() == matchingItem.size) {
                Main.info("Looks like we already have current copy of " + target.getName() + ", skipping it");
                continue;
            }
            Main.info("Sizes do not match - downloading again " + target.getName());
            BlockBlobURL blobURL = containerURL.createBlockBlobURL(matchingItem.name);
            Main.getBlob(blobURL, target);
        }
    }

    private static void get(ContainerURL containerURL, File destFolder) {
        Main.list(containerURL);
        for (Item item : blobList) {
            BlockBlobURL blobURL;
            File target = new File(destFolder, item.name);
            if (!target.exists()) {
                blobURL = containerURL.createBlockBlobURL(item.name);
                Main.getBlob(blobURL, target);
                continue;
            }
            if (target.length() == item.size) {
                Main.info("Looks like we already have current copy of " + target.getName() + ", skipping it");
                continue;
            }
            Main.info("Sizes do not match - downloading again " + target.getName());
            blobURL = containerURL.createBlockBlobURL(item.name);
            Main.getBlob(blobURL, target);
        }
    }

    private static void getBlob(BlockBlobURL blobURL, File targetFile) {
        try {
            blobURL.download(new BlobRange().withOffset(0L).withCount(Long.valueOf(0x40000000L)), null, false, null).flatMapCompletable(response -> {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(Paths.get(targetFile.getPath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                return FlowableUtil.writeFile((Flowable)response.body(null), (AsynchronousFileChannel)channel);
            }).doOnComplete(() -> Main.info("The blob was downloaded to " + targetFile.getAbsolutePath())).blockingAwait();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void info(String msg) {
        if (!silent) {
            slf4jLogger.info(msg);
        }
    }

    private static void error(String msg) {
        if (!silent) {
            slf4jLogger.error(msg);
        }
    }

    private static void help() {
        System.out.println("Toke Digital - Azure Blobstore Client, version 1.0.3");
        System.out.println("Author: David R. Smith <dave.smith10@det.nsw.edu.au>");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("-c --config           | Config file location, required");
        System.out.println("-s --silent           | Do not emit any console log output - useful for ansible");
        System.out.println("-i --idempotent       | Attempt to copy only if not present");
        System.out.println("-v --verb <command>   | Commands: list, get, getAll, send, required");
        System.out.println("-f --file <name>      | The filename to get, or the full file path to send");
        System.out.println("-d --dest <folder>    | use with get, the folder to put the file(s)");
        System.out.println("");
        System.out.println("-h --help             | Show this help");
        System.out.println("");
    }
}

