package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import digital.tail.sdk.tail_mobile_sdk.exception.TailDMPException;

/**
 * Created by babadopulos on 15/03/17.
 */

 class TailDMP_Config {

    public static final String NAMESPACE = "TailDMP";
    public static final String LAST_REQUEST = "lastRequest";
    public static final String SAVED_VALUES = "savedValues";
    public static final String SANDBOX_ENABLED = "sandboxEnabled";

    public static final String CONFIG_FILE = "TailDMPConfig.json";

    private JSONObject configJson = null;


    public synchronized void initialize(Context context) throws TailDMPException {
        initialize(context, CONFIG_FILE);
    }

    public synchronized void initialize(Context context, String configFile) throws TailDMPException {
        InputStream configInputStream = null;
        String json = null;

        try {
            configInputStream = context.getAssets().open(configFile);

            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(configInputStream));

            String line;
            StringBuilder sb = new StringBuilder();

            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }

            configJson = new JSONObject(sb.toString());

            //Log.d("TAIL-SDK", "json: " + configJson.toString());

        } catch (JSONException e) {
            e.printStackTrace();
            throw new TailDMPException("TailDMP: Error decoding config file '" + configFile + "'.");
        } catch (IOException e) {
            e.printStackTrace();
            throw new TailDMPException("TailDMP: Config file '" + configFile + "' must be placed in the assets folder.");
        } finally {
            if (configInputStream != null) {
                try {
                    configInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }

    public String getAccountID(){

        String str = "";
        try{
            str =configJson.getString("accountId");
        }catch (JSONException e){
            Log.e(TailDMPValues.TAG, "There is no AccountID, please add it in Config file: "+CONFIG_FILE+", this file must be placed in the assets folder.");
        }


        return str;
    }

    public String getConfig() {
        if (configJson == null) {
            return null;
        }
        return configJson.toString();
    }

}
