package digital.tail.sdk.tail_mobile_sdk;

import android.app.Activity;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;

import digital.tail.sdk.tail_mobile_sdk.exception.TailDMPException;

/**
 * Created by diego_saito on 8/7/17.
 */

 public class TailDMPSendDataJobService extends JobService {

    /**
     * VARS
     */

    private final static String TAG = TailDMPValues.TAG;

    //reference to main activity in case we need to send messages to it
    private Activity refActivity;

    //the operation to be done by this service
    private AsyncTask asyncOperation ;

    // ID of this job
    private int JOB_ID = 91553;

    //reference to scheduler
    private JobScheduler _jobScheduler;

    //reference to job that will be executed
    private JobInfo _build;

    //context
    private Context _context ;

    //callback that send messages to some activity
    private Messenger _callback;

    private TailDMPDeviceMapping datamap;

    //get the app data
    private TailDMP ref = null;

    @Override
    public void onCreate() {
        super.onCreate();
        //Log.i(TAG,"++++++ TailDMPSendDataJobService onCreate()");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        _context = null;
        //Log.i(TAG,"++++++ TailDMPSendDataJobService onDestroy()");
    }

    @Override
    public boolean onStartJob(final JobParameters params) {


        try {
            ref = TailDMP.getInstance();
        }catch (TailDMPException e) {
            e.printStackTrace();
        }finally{
            if(ref == null){
                forceInitTailDMP();
            }
        }


        if(ref !=null){
            //try to update geolocation
            ref.deviceMapping.getGeoLocationData();
            //reload all apps
            ref.deviceMapping.listAllApps();

        }

        if(asyncOperation == null) {
            //creates a new Async
            asyncOperation = new TAsyncSendJSON(this,ref.deviceMapping) {
                String res = "";
                @Override
                protected void onPostExecute(String resultFromAsync) {
                    //Log.i(TAG, "TAsyncSendData called from TailDMpJobService, finished call!!! - onPostExecute()" + resultFromAsync);
                    //res = resultFromAsync;
                    //save tags to devicemaps
                    //ref.deviceMapping.setTagsStringToArrayList(resultFromAsync);


                    // we must force the service to be finished
                    jobFinished(params, false);
                    //send message to activity
                    // sendMessage();

                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                        //if android N restart the job,
                        //Android N doesn' allow us to schedule jobs within 10 mins or less
                        //to ensure that the job will be rescheduled we recreate the job
                        ref.startJobWithID(JOB_ID);

                    }
                }
            };
        }

        if(asyncOperation.getStatus() != AsyncTask.Status.RUNNING){
            //exec async operation
            asyncOperation.execute();
        }



        return true;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        //Log.i(TAG,"++++ TailDMPSendDataJobService - onUnbind()");
        return super.onUnbind(intent);

    }

    @Override
    public void onRebind(Intent intent) {
        super.onRebind(intent);

        //Log.i(TAG,"++++ TailDMPSendDataJobService - onRebind()");
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        //Log.i(TAG,"++++ TailDMPSendDataJobService - onConfigurationChanged()");
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        //Log.i(TAG,"++++ TailDMPSendDataJobService - onStopJob()");
        //stop the async operation
        if(asyncOperation != null){
            asyncOperation.cancel(true);
        }
        return true;
    }

    public void setUICallback(Activity activity) {
        refActivity = activity;
    }

    // This method is called when the start command is fired
    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        //Log.i(TAG,"++++ TailDMPSendDataJobService - onStartCommand()");
        return START_NOT_STICKY;
    }


    /**
     * Called by onStartJob
     *  There're some situations that Android framework puts TailDMP singleton to be garbage collected,
     *  so we loose the reference of this object.
     *  We need to reinitialize it
     */

    private void forceInitTailDMP(){

        try {
            TailDMP.initialize(getApplicationContext());
            ref = TailDMP.getInstance();
            ref.deviceMapping.reloadDatafromDB();

        } catch (TailDMPException e) {
            e.printStackTrace();
        }finally {
            //Log.d(TailDMPValues.TAG,"+++ FORCE INIT++++"+ref);
        }
    }

    //send messages back to Activity
    private void sendMessage( ){

        Message m = Message.obtain();
        m.what = 2;
        m.obj = this;

        try {
            _callback.send(m);
        } catch (RemoteException e) {
            Log.e(TailDMP.TAG, "Error passing service object back to activity.");
        }
    }



    // Method that schedules the job, the job info and context comes from main activity
    public void scheduleJob(JobInfo build, Context context) {
        Log.i(TAG,"Scheduling job TailDMPSendDataJobService, wait until it starts");

        this._build = build;
        this._context = context;
        this._jobScheduler = (JobScheduler)context.getSystemService(Context.JOB_SCHEDULER_SERVICE);
        //jobScheduler.cancel(JOB_ID);
        //this._jobScheduler.cancelAll();
        this._jobScheduler.schedule(_build);

    }

    public void startJobService(JobInfo build,Context context){


        _build = build;
        _jobScheduler = (JobScheduler)context.getSystemService(Context.JOB_SCHEDULER_SERVICE);
        //_jobScheduler.cancelAll();
        _jobScheduler.schedule(_build );
        Log.i(TAG,"TailDMPSendDataJobService ==> START SERVICE");
    }

    public void stopJobService(Context context){
        _jobScheduler = (JobScheduler)context.getSystemService(Context.JOB_SCHEDULER_SERVICE);
        _jobScheduler.cancelAll();
        Log.i(TAG,"TailDMPSendDataJobService <== STOP SERVICE");

    }

    /**
     *
     * SETTERS/GETTERS
     */

    public void setDatamap(TailDMPDeviceMapping datamap) {
        this.datamap = datamap;
    }
}
