package digital.tail.sdk.tail_mobile_sdk;

import android.Manifest;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;

/**
 * Created by diego_saito on 5/5/17.
 */

 class TailDMPGeoLocation implements LocationListener {

    protected static final String TAG = "TAIL-SDK";
    private Context context;

    private Location location;
    LocationManager locationManager;
    private double latitude; // latitude
    private double longitude; // longitude

    // flag for GPS status
    boolean isGPSEnabled = false;

    // flag for network status
    boolean isNetworkEnabled = false;

    // The minimum distance to change Updates in meters
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 1; // 1 meters

    // The minimum time between updates in milliseconds
    private static final long MIN_TIME_BW_UPDATES = 10000; // 10 sec

    public TailDMPGeoLocation(Context context) {
        this.context = context;

        //startTrackLocation();
        //Log.i(TAG,"TailDMPGeoLocation");
    }

    public Location startTrackLocation(){

        try{

            //creates location manager
            locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);

            //check if we have permissions
            if (ContextCompat.checkSelfPermission(context, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED || ContextCompat.checkSelfPermission(context, Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED) {

                //checks if we have GPS or WIFI enabled
                isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
                isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);

                if (!isNetworkEnabled && !isGPSEnabled) {
                    // we can't get lat/long data 'cos there's no wifi nor GPS enabled
                    Log.e(TAG,"We can't get lat/long data because there's no wifi nor GPS enabled ");

                } else {

                    // if Wifi Enabled get lat/long using GPS Services
                    if (isNetworkEnabled) {
                        locationManager.requestLocationUpdates(
                                LocationManager.NETWORK_PROVIDER,
                                MIN_TIME_BW_UPDATES,
                                MIN_DISTANCE_CHANGE_FOR_UPDATES, this);
                        Log.i(TAG, "Network Enabled");
                        if (locationManager != null) {
                            location = locationManager
                                    .getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                            if (location != null) {
                                latitude = location.getLatitude();
                                longitude = location.getLongitude();
                            }
                        }
                    }

                    // if GPS Enabled get lat/long using GPS Services
                    if (isGPSEnabled) {
                        if (location == null) {
                            locationManager.requestLocationUpdates(
                                    LocationManager.GPS_PROVIDER,
                                    MIN_TIME_BW_UPDATES,
                                    MIN_DISTANCE_CHANGE_FOR_UPDATES, this);
                            Log.i(TAG, "GPS Enabled");
                            if (locationManager != null) {
                                location = locationManager
                                        .getLastKnownLocation(LocationManager.GPS_PROVIDER);
                                if (location != null) {
                                    latitude = location.getLatitude();
                                    longitude = location.getLongitude();
                                }
                            }
                        }
                    }

                }

            }else{

                Log.e(TAG,"We can't get lat/long data because we don't have permission to do it.");
            }

        }catch(Exception e){
            e.printStackTrace();
        }

        return location;
    }

    public void stopLocationTrack(){
        if(locationManager != null){
            locationManager.removeUpdates(TailDMPGeoLocation.this);
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        //listen  for location changes
        //Log.e(TAG," TailDMPGeoLocation onLocationChanged()"+latitude +" : "+longitude);
        if(location != null) {
            latitude = location.getLatitude();
            longitude = location.getLongitude();
            stopLocationTrack();
        }
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
        //Log.i(TAG," TailDMPGeoLocation onStatusChanged()");
    }

    @Override
    public void onProviderEnabled(String provider) {
        //Log.i(TAG," TailDMPGeoLocation onProviderEnabled()");
    }

    @Override
    public void onProviderDisabled(String provider) {
        //Log.i(TAG," TailDMPGeoLocation onProviderDisabled()");
    }
}
