package digital.tail.sdk.tail_mobile_sdk;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.location.Location;
import android.os.AsyncTask;
import android.os.Build;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.gson.Gson;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import digital.tail.sdk.tail_mobile_sdk.exception.TailDMPException;

import static com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo;
import static java.lang.System.exit;

/**
 * Created by babadopulos on 08/02/17.
 */

//class visible only for its package
class TailDMPDeviceMapping extends BroadcastReceiver{
    protected static final String TAG = "TAIL-SDK";

    private String apiVersion = android.os.Build.VERSION.SDK_INT+"";

    private String userHashTel;
    private String userHash;
    private String userHashEmail;
    private String userHashCPF;
    private String advertisingId;
    private ArrayList<String> tags;
    private TailDMPGeoLocation geo;
    private Double latitude;
    private Double lastLatitude;
    private Double longitude;
    private Double lastLongitude;
    private String language;
    private String timezone ;
    private String os = Build.VERSION.RELEASE;
    private String brand = Build.BRAND;
    private String device = Build.DEVICE;
    private String hardware = Build.HARDWARE;
    private String manufacturer = Build.MANUFACTURER;
    private String model = Build.MODEL;
    private String product = Build.PRODUCT;
    private String accountID = "";

    private String activity = "";

    private String currentApp = "";

    private String carrierName = "";

    private ArrayList<String> apps;

    private Context context;

    private TailDMP_Crypto cripto;

    private TelephonyManager telmanager;

    public TailDMPData reloadedUserdata;

    public String updateCollectJobTime ="";
    public String updateSendJobTime ="";

    public boolean sandboxEnabled = false;

    //ENDPOINT PROD
    private final String TAIL_API_ENDPOINT_PROD = "https://t.tailtarget.com/mobile";

    // SANDBOX HLG
    private final String TAIL_API_ENDPOINT_SANDBOX_HLG = "https://hlg-api.tailtarget.com/api/v2/sandbox/mobile";

    // SANDBOX PROD - UTILIZAR ESSE
    private final String TAIL_API_ENDPOINT_SANDBOX_PROD = "https://api.tailtarget.com/api/v2/sandbox/mobile";


    public TailDMPDeviceMapping(Context context) {
        this.context = context;
        cripto = new TailDMP_Crypto();
        timezone = TimeZone.getDefault().getID();
        language = Locale.getDefault().getDisplayLanguage();

        telmanager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        carrierName = telmanager.getNetworkOperatorName();

        resolveAdvertiserID();
        listAllApps();
        getGeoLocationData();
    }


    @Override
    public void onReceive(Context context, Intent intent) {

    }

    //returns the correct ENDPOINT, the production or the sandbox.
    public String getEndPointURL(){

        if(sandboxEnabled){
            return TAIL_API_ENDPOINT_SANDBOX_PROD;
            //return TAIL_API_ENDPOINT_SANDBOX_HLG;
        }else{
            return TAIL_API_ENDPOINT_PROD;
        }

    }

    public String getAdvertisingId() {
        return advertisingId;
    }


    public void pupulateAdvID(String advID){

        Map<String, String> dt2update = new HashMap<String, String>();

        dt2update.put(TailDMPDb.DB_FIELD_ADVERTISINGID,advID);

        TailDMPDb db = TailDMPDb.getInstance(context);
        db.updateData(dt2update);
    }






    public void resolveAdvertiserID() {




        TAsyncAdvID task = new TAsyncAdvID(context){
            @Override
            protected void onPostExecute(String id) {

                if(!id.isEmpty()) {
                     advertisingId = id;
                    pupulateAdvID(id);
                }


            }
        };
        task.execute();

    }

    /**
     * List all apps
     */
    public void listAllApps(){
        apps = null;
        apps = new ArrayList<String>();

        boolean error = false;
        try{

            PackageManager pm = context.getPackageManager();
            List<ApplicationInfo> appsList = pm.getInstalledApplications(0);

            for(ApplicationInfo app : appsList) {
                //checks for flags; if flagged, check if updated system app
                if((app.flags & ApplicationInfo.FLAG_UPDATED_SYSTEM_APP) != 0) {

                    //it's a system app, not interested
                } else if ((app.flags & ApplicationInfo.FLAG_SYSTEM) != 0) {
                    //Discard this one
                    //in this case, it should be a user-installed app
                } else {
                    //Log.d("CATEGORY","CAT");
                    if (!appExistonList(app.packageName)){
                        //add only if app dont exists on list
                        apps.add(app.packageName);
                    }

                }
            }

        }catch(Exception e){
            error = true;
            e.printStackTrace();

        }

        //save error on DB
        if(error){
            TAsyncSaveErrorList  errService = new TAsyncSaveErrorList(context,TailDMPValues.ERROR_TOO_MUCH_APPSLIST);
            Map <String, String > mp = new HashMap<String,String>();
            errService.execute(mp);

        }



    }



    private boolean appExistonList(String val){

        boolean appexists = false;

        if (apps != null){

            int len = apps.size();

            for (int i =0; i<len; i++){

                String ap = apps.get(i);

                if(ap.equals(val)){
                    //this app alredy exists
                    appexists = true;

                }else{
                    appexists = false;
                }
            }

        }

        return appexists;

    }


    public ArrayList getAllApps() {
        listAllApps();

        return apps;
    }

    public  synchronized String getAppsJSONFormated (){

        ArrayList<String> apps = null;
        apps = new ArrayList<String>();

        boolean error = false;

        try{

            PackageManager pm = context.getPackageManager();
            List<ApplicationInfo> appsList = pm.getInstalledApplications(0);


            for(ApplicationInfo app : appsList) {
                //checks for flags; if flagged, check if updated system app
                if((app.flags & ApplicationInfo.FLAG_UPDATED_SYSTEM_APP) != 0) {

                    //it's a system app, not interested
                } else if ((app.flags & ApplicationInfo.FLAG_SYSTEM) != 0) {
                    //Discard this one
                    //in this case, it should be a user-installed app
                } else {
                    //Log.d("CATEGORY","CAT");
                    // (!appExistonList(app.packageName)){
                        //add only if app dont exists on list
                        apps.add(app.packageName);
                    //}

                }
            }

        }catch(Exception e){
            error = true;
            e.printStackTrace();

        }

        //save error on DB
        if(error){
            TAsyncSaveErrorList  errService = new TAsyncSaveErrorList(context,TailDMPValues.ERROR_TOO_MUCH_APPSLIST);
            Map <String, String > mp = new HashMap<String,String>();
            errService.execute(mp);

        }


        String strresult = "";
        if(apps != null && apps.size()>0) {
            for (int i = 0; i < apps.size(); i++) {
                if (i != apps.size() - 1) {
                    strresult += "" + apps.get(i) + ",";
                } else {
                    strresult += "" + apps.get(i) + "";
                }
            }
        }
        strresult += "";

        return strresult;
    }

    private void reloadOptin(String val){



        TailDMP tDMP = null;

        boolean opt = false;

        if(val.equals("1")){
            opt = true;
        }else{
            opt = false;
        }

        //Log.e(TAG, "RELOD OPTIN " +val +" opt: "+ opt);

        try{
            tDMP = TailDMP.getInstance();
            tDMP.setOptin(opt);
        }  catch (TailDMPException e) {
            e.printStackTrace();
        }

    }

    private void reloadSendWIFI(String val){
        TailDMP tDMP = null;

        boolean vl = false;

        if(val.equals("1")){
            vl = true;
        }else{
            vl = false;
        }


        try{
            tDMP = TailDMP.getInstance();
            tDMP.setSendDataOnWifiOnly(vl);
        }  catch (TailDMPException e) {
            e.printStackTrace();
        }

    }

    private void reloadSandboxEnabled(){

        TailDMP tDMP = null;

       SharedPreferences preferences = context.getSharedPreferences(TailDMP_Config.NAMESPACE, Context.MODE_PRIVATE);

        String enabled = preferences.getString(TailDMP_Config.SANDBOX_ENABLED, null);
        if (enabled != null) {
            if(enabled.equals("1")){
                sandboxEnabled = true;
            }else{
                sandboxEnabled = false;
            }
        }

        try{
            tDMP = TailDMP.getInstance();
            tDMP.enableSandbox(sandboxEnabled);
        }  catch (TailDMPException e) {
            e.printStackTrace();
        }

    }

    //When we are in back ground, the device mapping data must be reloaded
    public void reloadDatafromDB(){

        try {
            //reload apps
            //listAllApps();

            //reload geolocation
            getGeoLocationData();

            //get database Helper
            TailDMPDb dbHelper = TailDMPDb.getInstance(this.context);
            //TailDMPData userdata = db.getUserData();

            //get a database
            SQLiteDatabase db = dbHelper.getdatabase();

            //reload sandbox
            reloadSandboxEnabled();

            //get user data async
            TAsyncGetUserData t = new TAsyncGetUserData(db) {

                @Override
                protected void onPostExecute(TailDMPData resultFromAsync) {
                    super.onPostExecute(resultFromAsync);

                    //userdata returned by query
                    reloadedUserdata = resultFromAsync;

                    //set data back to device map
                    userHash = resultFromAsync.userHash;
                    userHashTel = resultFromAsync.userHashTel;
                    userHashCPF = resultFromAsync.userHashCPF;
                    userHashEmail = resultFromAsync.userHashEmail;
                    advertisingId = resultFromAsync.advertisingId;
                    device = resultFromAsync.device;
                    model = resultFromAsync.model;
                    product = resultFromAsync.product;
                    brand = resultFromAsync.brand;
                    os = resultFromAsync.os;
                    hardware = resultFromAsync.hardware;
                    manufacturer = resultFromAsync.manufacture;
                    carrierName = resultFromAsync.carrierName;
                    accountID = resultFromAsync.accountID;
                    updateCollectJobTime = resultFromAsync.updateCollectJobTime;
                    updateSendJobTime = resultFromAsync.updateSendJobTime;

                    reloadOptin(resultFromAsync.optin);
                    reloadSendWIFI(resultFromAsync.sendDataWifiOnly);

                    //we must handle tags data to be used later
                    ArrayList<String> listtags = new ArrayList<String>(Arrays.asList(resultFromAsync.tags.split(",")));
                    //Log.e(TailDMPValues.TAG,"DUMP RECOVERY TAGS: "+listtags.toString()+" LEN DA LISTA"+ listtags.size());
                    tags = listtags;

                    String appzz = "";
                    if (apps != null) {
                        appzz = apps.size() + "";
                    }

                    //ArrayList<String> arr = new ArrayList<String>(Arrays.asList(resultFromAsync.apps.split(",")));
                    //Log.i(TAG,"RELOADED APPS: "+resultFromAsync.apps.length() +" DEVICEMAP APP SIZE: " +appzz );


                    //close db
                    //db.close();


                }
            };
            t.execute();
        }catch(Exception e){
            e.printStackTrace();
        }

    }


    /**
     * Get latitude and longitude if allowed by user
     */
    public void getGeoLocationData(){
        //use geolocation class to get lat and long

        Location loc = null;

        try{
            this.geo = new TailDMPGeoLocation(context);
            loc = geo.startTrackLocation();

        }catch(Exception e){
            e.printStackTrace();
        }

        if(loc != null){
          latitude = loc.getLatitude();
          longitude = loc.getLongitude();
        }
        //Log.i(TAG,"TAILDMPDeviceMapping - getGeoLocationData() LAT/LONG"+latitude+" : "+longitude);
    }


    /**
     *
     * HELPER
     */
    public boolean hasMinimunData(){

        boolean minimumData = false;

        if(accountID== null){
            Log.i(TAG,"You don't have AccountID, please add it to TailDMPConfig.json on your assets folder");
            minimumData = false;
        }else{
            minimumData = true;
        }

        return minimumData;
    }

    /**
     *
     * SETTERS AND GETTERS
     */

    public String getUserHash() {
        return userHash;
    }

    public void setUserHash(String userHash) {
        this.userHash = userHash;
    }

    public void setUserHashNotEncrypted(String userHash){
        this.userHash = userHash;
    }
    public void setUserHashEmailNotEncrypted(String userHash){
        this.userHashEmail = userHash;
    }
    public void setUserHashCPFNotEncrypted(String userHash){
        this.userHashCPF = userHash;
    }
    public void setUserHashTelNotEncrypted(String userHash){
        this.userHashTel = userHash;
    }

    public ArrayList<String> getTags() {
        return tags;
    }

    public String getTagsJSONFormated(){

        String jsonTags="";


        if(tags != null && tags.size() >0){
            jsonTags = tags.get(0);
        }


        /*
        if(tags != null){
            for(int i = 0; i<tags.size(); i++){
                if(i != tags.size() -1){
                    jsonTags+=tags.get(i)+",";
                }else{
                    jsonTags+=tags.get(i)+"";
                }
            }
        }else{
            jsonTags =" ";
        }*/


        return jsonTags;
    }


    public void setTags(String tag) {

        final String tgs = tag;

        if(hasMinimunData()){
            //getdatabase
            try {
                TailDMPDb dtHelper = TailDMPDb.getInstance(context);
                SQLiteDatabase db = dtHelper.getdatabase();
                //savedata on db
                TAsyncAddOrUpdateTag t = new TAsyncAddOrUpdateTag(db) {
                    @Override
                    protected void onPostExecute(String s) {
                        super.onPostExecute(s);
                        ArrayList<String> tg = new ArrayList<String>();
                        tg.add(tgs);
                        tags = tg;
                        Log.i(TailDMP.TAG, "Tag Added!");
                    }
                };
                t.execute(tag);
            }catch(Exception e){
                e.printStackTrace();
            }
        }

    }



    public void setTagsStringToArrayList(String comaSeparated){
        //we must handle tags data to be used later
        ArrayList<String>listtags = new ArrayList<String>(Arrays.asList(comaSeparated.split(",")));
        this.tags = listtags;

    }


    public String getCurrentApp() {
        return currentApp;
    }

    public void setCurrentApp(String currentApp) {
        this.currentApp = currentApp;
    }

    public void setAccountID(String accountID){
        this.accountID = accountID;
    }

    public String getAccountID(){
        return this.accountID;
    }


    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public ArrayList<String> getApps() {
        return apps;
    }

    public void setApps(ArrayList<String> apps) {
        this.apps = apps;
    }

    public String getBrand() {
        return brand;
    }

    public String getDevice() {
        return device;
    }

    public String getHardware() {
        return hardware;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public String getModel() {
        return model;
    }

    public String getProduct() {
        return product;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public String getCarrierName() {
        return carrierName;
    }

    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public Double getLastLatitude() {
        return lastLatitude;
    }

    public void setLastLatitude(Double lastLatitude) {
        this.lastLatitude = lastLatitude;
    }

    public Double getLastLongitude() {
        return lastLongitude;
    }

    public void setLastLongitude(Double lastLongitude) {
        this.lastLongitude = lastLongitude;
    }

    public String getUserHashTel() {
        return userHashTel;
    }

    public void setUserHashTel(String userHashTel) {
        this.userHashTel = TailDMP.convertToSHA256(userHashTel.toLowerCase());

        Map<String, String> dt2update = new HashMap<String, String>();

        String hash = generateCompositeUserHash(this.userHashEmail,this.userHashCPF,this.userHashTel);

        dt2update.put(TailDMPDb.DB_FIELD_USERHASH,hash);

        Log.i(TAG,"User hash created!");

        dt2update.put(TailDMPDb.DB_FIELD_USERHASH_TEL,this.userHashTel);
        TailDMPDb db = TailDMPDb.getInstance(context);
        db.updateData(dt2update);
    }

    public String getUserHashEmail() {
        return userHashEmail;
    }

    public void setUserHashEmail(String userHashEmail) {
        this.userHashEmail = TailDMP.convertToSHA256(userHashEmail.toLowerCase());

        Map<String, String> dt2update = new HashMap<String, String>();

        String hash = generateCompositeUserHash(this.userHashEmail,this.userHashCPF,this.userHashTel);

        dt2update.put(TailDMPDb.DB_FIELD_USERHASH,hash);
        dt2update.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL,this.userHashEmail);

        Log.i(TAG,"User hash created!");

        TailDMPDb db = TailDMPDb.getInstance(context);
        db.updateData(dt2update);
    }

    public String getUserHashCPF() {
        return userHashCPF;
    }

    public void setUserHashCPF(String userHashCPF) {
        this.userHashCPF = TailDMP.convertToSHA256(userHashCPF.toLowerCase());

        Map<String, String> dt2update = new HashMap<String, String>();

        String hash = generateCompositeUserHash(this.userHashEmail,this.userHashCPF,this.userHashTel);

        dt2update.put(TailDMPDb.DB_FIELD_USERHASH,hash);
        dt2update.put(TailDMPDb.DB_FIELD_USERHASH_CPF,this.userHashCPF);

        Log.i(TAG,"User hash created!");

        TailDMPDb db = TailDMPDb.getInstance(context);
        db.updateData(dt2update);

    }

    private String generateCompositeUserHash(String emailHash, String cpfHash, String telHash){

        String userhash2Send = "";



            if (emailHash != null && emailHash.length() >1){

                userhash2Send += ";"+emailHash;
            }
            if (cpfHash != null && cpfHash.length() >1){

                userhash2Send += ";"+cpfHash;
            }
            if (telHash != null && telHash.length() >1){

                userhash2Send += ";"+telHash;
            }

            if(userhash2Send.length() >0){
                userhash2Send = userhash2Send.substring(1);
            }


        return userhash2Send;

    }

}
