package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;

import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by diego_saito on 5/9/17.
 */


 class TailDMPDb extends SQLiteOpenHelper {

    //database version inscrease it by one on every deploy
    public static final int DATABASE_VERSION = 32;
    public static final String DATABASE_NAME = "tailtargetDB";

    public static final String USER_ID = 9999+"";

    public static final String USER_ID_SEND_DATA = 91553+"";

    //table name
    public static final String DATABASE_TABLE_NAME = "tailtargetdata";

    //table fields
    public static final String DB_FIELD_USER_ID = "user_id";
    public static final String DB_FIELD_APIVERSION = "apiVersion";
    public static final String DB_FIELD_USERHASH = "userHash";
    public static final String DB_FIELD_USERHASH_EMAIL = "userHashEmail";
    public static final String DB_FIELD_USERHASH_CPF = "userHashCPF";
    public static final String DB_FIELD_USERHASH_TEL = "userHashTel";
    public static final String DB_FIELD_ADVERTISINGID = "advertisingId";
    public static final String DB_FIELD_TAGS = "tags";
    public static final String DB_FIELD_LATITUDE = "latitude";
    public static final String DB_FIELD_LASTLATITUDE = "lastLatitude";
    public static final String DB_FIELD_LONGITUDE = "longitude";
    public static final String DB_FIELD_LASTLONGITUDE = "lastLongitude";
    public static final String DB_FIELD_LANGUAGE = "language";
    public static final String DB_FIELD_TIMEZONE = "timezone";
    public static final String DB_FIELD_OS = "os";
    public static final String DB_FIELD_APPS = "apps";
    public static final String DB_FIELD_LAST_REQUEST = "lastRequest";
    public static final String DB_FIELD_BRAND = "brand";
    public static final String DB_FIELD_PRODUCT = "product";
    public static final String DB_FIELD_DEVICE = "device";
    public static final String DB_FIELD_HARDWARE = "hardware";
    public static final String DB_FIELD_MANUFACTURER = "manufacturer";
    public static final String DB_FIELD_MODEL = "model";
    public static final String DB_FIELD_CARRIER_NAME = "carrierName";
    public static final String DB_FIELD_UPDATE_COLLECT_JOB_TIME = "updateCollectJobTime";
    public static final String DB_FIELD_UPDATE_SEND_JOB_TIME = "updateSendJobTime";
    public static final String DB_FIELD_ACCOUNTID = "accountID";
    public static final String DB_FIELD_CURRENTAPP = "currentApp";
    public static final String DB_FIELD_ACTIVITY = "activity";
    public static final String DB_FIELD_SEND_DATA_WIFIONLY = "sendDataWifiOnly";
    public static final String DB_FIELD_TAIL_SDK_VERSION = "tailSDKVersion";
    public static final String DB_FIELD_OPTIN = "optin";
    public static final String DB_FIELD_ERRORLIST = "errorList";



    public static final int DB_VALUE_UPDATE_JOB_DAILLY = 86400000;
    public static final int DB_VALUE_UPDATE_JOB_HALFDAY = 43200000;
    public static final int DB_VALUE_UPDATE_JOB_HOURLY = 3600000;
    public static final int DB_VALUE_UPDATE_JOB_INAMINUTE = 60000;
    public static final int DB_VALUE_UPDATE_JOB_15MINUTES = 900000;
    public static final int DB_VALUE_UPDATE_JOB_4HOURS = 14400000;
    public static final int DB_VALUE_UPDATE_JOB_ALLDATA = 21600000; //send all data 360 min /6h.


    public static final ArrayList <String> dbfields = new ArrayList<String>(){{
        add(TailDMPDb.DB_FIELD_USER_ID );
        add(TailDMPDb.DB_FIELD_APIVERSION );
        add(TailDMPDb.DB_FIELD_USERHASH );
        add(TailDMPDb.DB_FIELD_USERHASH_EMAIL);
        add(TailDMPDb.DB_FIELD_USERHASH_CPF);
        add(TailDMPDb.DB_FIELD_USERHASH_TEL);
        add(TailDMPDb.DB_FIELD_ADVERTISINGID);
        add(TailDMPDb.DB_FIELD_TAGS );
        add(TailDMPDb.DB_FIELD_LATITUDE );
        add(TailDMPDb.DB_FIELD_LASTLATITUDE );
        add(TailDMPDb.DB_FIELD_LONGITUDE );
        add(TailDMPDb.DB_FIELD_LASTLONGITUDE );
        add(TailDMPDb.DB_FIELD_LANGUAGE );
        add(TailDMPDb.DB_FIELD_TIMEZONE );
        add(TailDMPDb.DB_FIELD_OS );
        add(TailDMPDb.DB_FIELD_APPS );
        add(TailDMPDb.DB_FIELD_LAST_REQUEST );
        add(TailDMPDb.DB_FIELD_BRAND );
        add(TailDMPDb.DB_FIELD_PRODUCT );
        add(TailDMPDb.DB_FIELD_DEVICE );
        add(TailDMPDb.DB_FIELD_HARDWARE );
        add(TailDMPDb.DB_FIELD_MANUFACTURER );
        add(TailDMPDb.DB_FIELD_MODEL );
        add(TailDMPDb.DB_FIELD_CARRIER_NAME );
        add(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME );
        add(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME );
        add(TailDMPDb.DB_FIELD_ACCOUNTID );
        add(TailDMPDb.DB_FIELD_CURRENTAPP );
        add(TailDMPDb.DB_FIELD_ACTIVITY );
        add(TailDMPDb.DB_FIELD_SEND_DATA_WIFIONLY );
        add(TailDMPDb.DB_FIELD_TAIL_SDK_VERSION );
        add(TailDMPDb.DB_FIELD_OPTIN );
        add(TailDMPDb.DB_FIELD_ERRORLIST);
    }};


    private static TailDMPDb sInstance;


    public static synchronized TailDMPDb getInstance(Context context) {
        // Use the application context, which will ensure that you
        // don't accidentally leak an Activity's context.
        // See this article for more information: http://bit.ly/6LRzfx
        if (sInstance == null) {

            sInstance = new TailDMPDb(context.getApplicationContext());
        }

        //Log.i(TailDMPValues.TAG,"TailDMPDb getInstance()");
        return sInstance;
    }


    private TailDMPDb (Context context){
        super(context, DATABASE_NAME, null, DATABASE_VERSION);



    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        Log.i(TailDMPValues.TAG,"CREATING NEW DB ....");

        //string to create table and fields
        String CREATE_TAILDATA_TABLE ="CREATE TABLE "+DATABASE_TABLE_NAME+
                " ( "+
                "user_id INTEGER , "+
                DB_FIELD_APIVERSION+" TEXT, "+
                DB_FIELD_USERHASH+" TEXT, "+
                DB_FIELD_USERHASH_EMAIL+" TEXT, "+
                DB_FIELD_USERHASH_CPF+" TEXT, "+
                DB_FIELD_USERHASH_TEL+" TEXT, "+
                DB_FIELD_ADVERTISINGID+" TEXT, "+
                DB_FIELD_TAGS+" TEXT, "+
                DB_FIELD_LATITUDE+" TEXT, "+
                DB_FIELD_LONGITUDE+" TEXT ,"+
                DB_FIELD_LANGUAGE+" TEXT, "+
                DB_FIELD_TIMEZONE+" TEXT, "+
                DB_FIELD_OS+" TEXT, "+
                DB_FIELD_APPS+" TEXT, "+
                DB_FIELD_BRAND+" TEXT, "+
                DB_FIELD_PRODUCT+" TEXT, "+
                DB_FIELD_DEVICE+" TEXT, "+
                DB_FIELD_HARDWARE+" TEXT, "+
                DB_FIELD_MANUFACTURER+" TEXT, "+
                DB_FIELD_MODEL+" TEXT, "+
                DB_FIELD_CARRIER_NAME+" TEXT, "+
                DB_FIELD_LAST_REQUEST+" TEXT, "+
                DB_FIELD_UPDATE_COLLECT_JOB_TIME+" INTEGER, "+
                DB_FIELD_UPDATE_SEND_JOB_TIME+" INTEGER, "+
                DB_FIELD_ACCOUNTID+" TEXT, "+
                DB_FIELD_CURRENTAPP+" TEXT, "+
                DB_FIELD_ACTIVITY+" TEXT, "+
                DB_FIELD_LASTLATITUDE+" TEXT, "+
                DB_FIELD_LASTLONGITUDE+" TEXT, "+
                DB_FIELD_SEND_DATA_WIFIONLY+" INTEGER, "+
                DB_FIELD_TAIL_SDK_VERSION+" TEXT, "+
                DB_FIELD_OPTIN+" INTEGER, "+
                DB_FIELD_ERRORLIST+" TEXT "+
                " ); ";



        //query insert empty data
        String INSERT_THE_USER = "INSERT INTO "+ DATABASE_TABLE_NAME+ " VALUES("+
                USER_ID+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", "+DB_VALUE_UPDATE_JOB_15MINUTES+
                ", "+DB_VALUE_UPDATE_JOB_4HOURS+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", ''"+
                ", 0"+
                ", '"+TailDMP.VERSION+"' "+
                ", 1"+
                ", ''"+
                ");";



        //db.setVersion(1);
        db.execSQL(CREATE_TAILDATA_TABLE);
        db.execSQL(INSERT_THE_USER);

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(TailDMPValues.TAG,"UPGRADE DB");
        String DROP_TABLE = "DROP TABLE IF EXISTS "+DATABASE_TABLE_NAME+" ;";
        db.execSQL(DROP_TABLE);
        onCreate(db);

    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.i(TailDMPValues.TAG,"DOWNGRADE DB");
       // super.onDowngrade(db, oldVersion, newVersion);
        String DROP_TABLE = "DROP TABLE IF EXISTS "+DATABASE_TABLE_NAME+" ;";
        db.execSQL(DROP_TABLE);
        onCreate(db);

    }

    @Override
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        db.enableWriteAheadLogging();
    }

    public void setUpdateJobTime(int timeToCollect, int timeToSend){

        try {

            // Get the database and run the query
            SQLiteDatabase db = getdatabase();
            db.beginTransaction(); //== POSSIBLE CRASH

            ContentValues values = new ContentValues();
            values.put(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME, timeToSend);
            values.put(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME, timeToCollect);

            int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID, null);
            if(rows == 1){
                Log.i(TailDMPValues.TAG,"Interval of job services updated!");
            }else{
                Log.i(TailDMPValues.TAG, "Interval of job services not updated!");
            }

            db.setTransactionSuccessful();

        } catch (Exception e) {
            Log.e(TailDMPValues.TAG, "Error while trying to add values to database"+e.getMessage());
        } finally {
            if(db != null){
                db.endTransaction();
            }
        }

    }

    public void updateActivity(String activityType){
        try{

            TAsyncUpdateActivity t = new TAsyncUpdateActivity(getdatabase());

            Map<String,String> dataToUpdate = new HashMap<String, String>();
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY      ,activityType);

            t.execute(dataToUpdate);
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public void updateErrorList(String errorList){

        try{
            TAsyncUpdateActivity t = new TAsyncUpdateActivity(getdatabase());

            Map<String,String> dataToUpdate = new HashMap<String, String>();
            dataToUpdate.put(TailDMPDb.DB_FIELD_ERRORLIST      ,errorList);

            t.execute(dataToUpdate);

        }catch(Exception e){
            e.printStackTrace();
        }
    }


    public void saveDataForLater(Map data){
        try {
            TAsyncSaveDataToSendLater t = new TAsyncSaveDataToSendLater(getdatabase());
            t.execute(data);
        }catch(Exception e){
            e.printStackTrace();
        }
    }



    public Map getUpdateJobTime(){

        Map <String, Integer>time = new HashMap<String, Integer>();

        Cursor cursor = null;
        try{

            // Get the database and run the query
            SQLiteDatabase db = getReadableDatabase();

            //query database to check if there is an user
            String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";
            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                do {

                   //time = cursor.getInt(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME));

                    time.put(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME, cursor.getInt(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME)));
                    time.put(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME, cursor.getInt(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME)));


                } while(cursor.moveToNext());
            }

        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database"+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }

        return time;

    }

    public TailDMPData userdata;

    public TailDMPData getUserData(){


        try{
            TAsyncGetUserData t = new TAsyncGetUserData(getdatabase()){

                @Override
                protected void onPostExecute(TailDMPData resultFromAsync) {
                    super.onPostExecute(resultFromAsync);

                    userdata = resultFromAsync;


                }
            };
            t.execute().get();
        }catch (Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data TailTarget server "+e.getMessage());
        }finally {
            return  userdata;
        }



    }


    private boolean isDbAvaiable(){
        if (db == null){
            return false;
        }else if(db.isOpen()){
            return true;
        }else {
            return false;
        }
    }

    SQLiteDatabase db = null;
    public SQLiteDatabase getdatabase(){

        if (db == null) {
            try {
                db = getWritableDatabase();  //== POSSIBLE CRASH
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        //debug
        //db = null;
        return db;
    }



    public void closeDB(){
        if(db.isOpen()){
            db.close();
        }
    }

    public void updateData(Map data){
        try {
            TAsyncUpdateData t = new TAsyncUpdateData(getdatabase()); //== POSSIBLE CRASH
            t.execute(data);
        }catch(Exception e){
            e.printStackTrace();
        }
    }



    // Insert a post into the database
    public void addData(TailDMPDeviceMapping data) {
        try {
            TAsyncAddData t = new TAsyncAddData(getdatabase());
            t.execute(data);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
}
