package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.os.Build;
import android.util.Log;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by diego_saito on 5/8/17.
 */

 class TailDMPData {

    public String apiVersion = "";
    public String userHashEmail = "";
    public String userHash = "";
    public String userHashCPF = "";
    public String userHashTel = "";
    public String advertisingId = "";
    public String tags = "";
    public String latitude = "";
    public String longitude = "";
    public String lastLatitude = "";
    public String lastLongitude = "";
    public String language = "";
    public String timezone = "";
    public String os = "";
    public String apps = "";
    public String brand = "";
    public String product = "";
    public String device = "";
    public String hardware = "";
    public String manufacture = "";
    public String model = "";
    public String lastrequest = "";
    public String carrierName ="";
    public String accountID = "";
    public String currentApp = "";
    public String activity = "";
    public String updateCollectJobTime ="";
    public String updateSendJobTime ="";
    public String tailSDKVersion ="";
    public String sendDataWifiOnly ="";
    public String optin ="";
    public String errorList = "";



    private String checkEmptyData(String data){
        String dt ="";

        String jsonEmpty = "\"\"" ;

        if(data == null || data.isEmpty() || data.equals("null") ){
            dt = jsonEmpty;
        }else{
            dt = data;
        }

        return dt;
    }


    public void populateTailDMPData(Map mapa){

        this.apiVersion = mapa.get(TailDMPDb.DB_FIELD_APIVERSION).toString();
        this.userHash= mapa.get(TailDMPDb.DB_FIELD_USERHASH).toString();
        this.userHashCPF = mapa.get(TailDMPDb.DB_FIELD_USERHASH_CPF).toString();
        this.userHashEmail= mapa.get(TailDMPDb.DB_FIELD_USERHASH_EMAIL).toString();
        this.userHashTel = mapa.get(TailDMPDb.DB_FIELD_USERHASH_TEL).toString();
        this.advertisingId = mapa.get(TailDMPDb.DB_FIELD_ADVERTISINGID).toString();
        this.tags = mapa.get(TailDMPDb.DB_FIELD_TAGS).toString();
        this.latitude = mapa.get(TailDMPDb.DB_FIELD_LATITUDE).toString();
        this.longitude = mapa.get(TailDMPDb.DB_FIELD_LONGITUDE).toString();
        this.lastLatitude = mapa.get(TailDMPDb.DB_FIELD_LASTLATITUDE).toString();
        this.lastLongitude = mapa.get(TailDMPDb.DB_FIELD_LASTLONGITUDE).toString();
        this.language = mapa.get(TailDMPDb.DB_FIELD_LANGUAGE).toString();
        this.timezone = mapa.get(TailDMPDb.DB_FIELD_TIMEZONE).toString();
        this.os = mapa.get(TailDMPDb.DB_FIELD_OS).toString();
        this.apps = mapa.get(TailDMPDb.DB_FIELD_APPS).toString();
        this.brand = mapa.get(TailDMPDb.DB_FIELD_BRAND).toString();
        this.product = mapa.get(TailDMPDb.DB_FIELD_PRODUCT).toString();
        this.device= mapa.get(TailDMPDb.DB_FIELD_DEVICE).toString();
        this.hardware = mapa.get(TailDMPDb.DB_FIELD_HARDWARE).toString();
        this.manufacture = mapa.get(TailDMPDb.DB_FIELD_MANUFACTURER).toString();
        this.model = mapa.get(TailDMPDb.DB_FIELD_MODEL).toString();
        this.lastrequest = mapa.get(TailDMPDb.DB_FIELD_LAST_REQUEST).toString();
        this.carrierName = mapa.get(TailDMPDb.DB_FIELD_CARRIER_NAME).toString();
        this.accountID = mapa.get(TailDMPDb.DB_FIELD_ACCOUNTID).toString();
        this.currentApp = mapa.get(TailDMPDb.DB_FIELD_CURRENTAPP).toString();
        this.activity = mapa.get(TailDMPDb.DB_FIELD_ACTIVITY).toString();
        this.updateCollectJobTime = mapa.get(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME).toString();
        this.updateSendJobTime = mapa.get(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME).toString();
        this.errorList = mapa.get(TailDMPDb.DB_FIELD_ERRORLIST).toString();
        this.tailSDKVersion = TailDMP.VERSION;



    }

    public Map toHashMap (){

        Map <String,String> map = new HashMap<String,String>();
        map.put(TailDMPDb.DB_FIELD_APIVERSION,this.apiVersion);
        map.put(TailDMPDb.DB_FIELD_USERHASH,this.userHash);
        map.put(TailDMPDb.DB_FIELD_USERHASH_CPF,this.userHashCPF);
        map.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL,this.userHashEmail);
        map.put(TailDMPDb.DB_FIELD_USERHASH_TEL,this.userHashTel);
        map.put(TailDMPDb.DB_FIELD_ADVERTISINGID,this.advertisingId);
        map.put(TailDMPDb.DB_FIELD_TAGS,this.tags);
        map.put(TailDMPDb.DB_FIELD_LATITUDE,this.latitude);
        map.put(TailDMPDb.DB_FIELD_LONGITUDE,this.longitude);
        map.put(TailDMPDb.DB_FIELD_LASTLATITUDE,this.lastLatitude);
        map.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,this.lastLongitude);
        map.put(TailDMPDb.DB_FIELD_LANGUAGE,this.language);
        map.put(TailDMPDb.DB_FIELD_TIMEZONE,this.timezone);
        map.put(TailDMPDb.DB_FIELD_OS,this.os);
        map.put(TailDMPDb.DB_FIELD_APPS,this.apps);
        map.put(TailDMPDb.DB_FIELD_BRAND,this.brand);
        map.put(TailDMPDb.DB_FIELD_PRODUCT,this.product);
        map.put(TailDMPDb.DB_FIELD_DEVICE,this.device);
        map.put(TailDMPDb.DB_FIELD_HARDWARE,this.hardware);
        map.put(TailDMPDb.DB_FIELD_MANUFACTURER,this.manufacture);
        map.put(TailDMPDb.DB_FIELD_MODEL,this.model);
        map.put(TailDMPDb.DB_FIELD_LAST_REQUEST,this.lastrequest);
        map.put(TailDMPDb.DB_FIELD_CARRIER_NAME,this.carrierName);
        map.put(TailDMPDb.DB_FIELD_ACCOUNTID,this.accountID);
        map.put(TailDMPDb.DB_FIELD_CURRENTAPP,this.currentApp);
        map.put(TailDMPDb.DB_FIELD_ACTIVITY,this.activity);
        map.put(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME,this.updateCollectJobTime);
        map.put(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME,this.updateSendJobTime);
        map.put(TailDMPDb.DB_FIELD_ERRORLIST,this.errorList);

        //always send our SDK's version
        map.put(TailDMPDb.DB_FIELD_TAIL_SDK_VERSION,TailDMP.VERSION);

        return map;

    }


    public String toJson(){


        String json = "{"+
                "\"apiVersion\":\""+apiVersion+"\","+
                "\"userHash\":\""+checkEmptyData(userHash)+"\","+
                "\"userHashEmail\":\""+checkEmptyData(userHashEmail)+"\","+
                "\"userHashCPF\":\""+checkEmptyData(userHashCPF)+"\","+
                "\"userHashTel\":\""+checkEmptyData(userHashTel)+"\","+
                "\"advertisingId\":\""+checkEmptyData(advertisingId)+"\","+
                "\"tags\":"+checkEmptyData(tags)+","+  //dont need quotes, its an array
                "\"latitude\":\""+checkEmptyData(latitude)+"\","+
                "\"longitude\":\""+checkEmptyData(longitude)+"\","+
                "\"language\":\""+checkEmptyData(language)+"\","+
                "\"timezone\":\""+checkEmptyData(timezone)+"\","+
                "\"os\":\""+checkEmptyData(os)+"\","+
                "\"apps\":"+checkEmptyData(apps)+","+  //dont need quotes, its an array
                "\"brand\":"+checkEmptyData(brand)+","+
                "\"product\":"+checkEmptyData(product)+","+
                "\"device\":"+checkEmptyData(device)+","+
                "\"hardware\":"+checkEmptyData(hardware)+","+
                "\"manufacture\":"+checkEmptyData(manufacture)+","+
                "\"model\":"+checkEmptyData(model)+","+
                "\"lastrequest\":\""+checkEmptyData(lastrequest)+"\","+
                "\"carrierName\":\""+checkEmptyData(carrierName)+"\","+
                "\"accountID\":\""+checkEmptyData(accountID)+"\","+
                "\"activity\":\""+checkEmptyData(activity)+"\","+
                "\"lastLatitude\":\""+checkEmptyData(lastLatitude)+"\","+
                "\"lastLongitude\":\""+checkEmptyData(lastLongitude)+"\","+
                "\"errorList\":\""+checkEmptyData(errorList)+"\","+
                "\"currentApp\":\""+checkEmptyData(currentApp)+"\""+

                "}";

        return json;
    }

    private boolean hasOneEmpty(String[] arrayString ){

        int len = arrayString.length;

        if (len == 1 ){
            //if theres only 1 item and is empty
            if(arrayString[0].isEmpty()){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }

    }

    public Map generateDataHash2Send(){

        Map <String,String> map = new HashMap<String,String>();


        String[] parts1;

        parts1 = this.apiVersion.split(";");
        if(parts1.length >0){

            map.put( TailDMPDb.DB_FIELD_APIVERSION,this.apiVersion );
        }

        parts1 = this.userHash.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_USERHASH,this.userHash);
        }

        parts1 = this.advertisingId.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_ADVERTISINGID,this.advertisingId);
        }

        parts1 = this.tags.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_TAGS, this.tags);
            }
        }

        parts1 = this.latitude.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_LATITUDE, this.latitude);
            }
        }

        parts1 = this.longitude.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_LONGITUDE, this.longitude);
            }
        }

        parts1 = this.lastLatitude.split(";");
        if(parts1.length >0){

            if (!hasOneEmpty(parts1)){
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_LASTLATITUDE,this.lastLatitude);
            }

        }

        parts1 = this.lastLongitude.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)){
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,this.lastLongitude);
            }
        }

        parts1 = this.language.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_LANGUAGE, this.language);
            }
        }

        parts1 = this.timezone.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_TIMEZONE,this.timezone);
        }

        parts1 = this.os.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_OS, this.os);
            }
        }

        parts1 = this.apps.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_APPS,this.apps);
        }

        parts1 = this.brand.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_BRAND, this.brand);
            }
        }

        parts1 = this.product.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)){
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_PRODUCT,this.product);
            }
        }

        parts1 = this.device.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_DEVICE, this.device);
            }
        }


        parts1 = this.hardware.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_HARDWARE, this.hardware);
            }
        }


        parts1 = this.manufacture.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_MANUFACTURER, this.manufacture);
            }
        }

        parts1 = this.model.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_MODEL, this.model);
            }
        }

        parts1 = this.lastrequest.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_LAST_REQUEST,this.lastrequest);
        }
        parts1 = this.carrierName.split(";");
        if(parts1.length >0){
            if (!hasOneEmpty(parts1)) {
                //check if we get 1 register and if its value is not empty
                map.put(TailDMPDb.DB_FIELD_CARRIER_NAME, this.carrierName);
            }
        }

        parts1 = this.accountID.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_ACCOUNTID,this.accountID);
        }

        parts1 = this.currentApp.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_CURRENTAPP,this.currentApp);
        }

        parts1 = this.activity.split(";");
        if(parts1.length >0){
            map.put(TailDMPDb.DB_FIELD_ACTIVITY,this.activity);
        }

        if(!this.errorList.isEmpty()){
            parts1 = this.errorList.split(";");
            if(parts1.length >0){
                map.put(TailDMPDb.DB_FIELD_ERRORLIST,this.errorList);
            }
        }


        //always send our SDK's version
        map.put(TailDMPDb.DB_FIELD_TAIL_SDK_VERSION,TailDMP.VERSION);

        return map;
    }


    public String toJson2Send(){


        String json = "{"+
                "\"apiVersion\":\""+apiVersion+"\","+
                "\"userHash\":\""+checkEmptyData(userHash)+"\","+
                //"\"userHashEmail\":\""+checkEmptyData(userHashEmail)+"\","+
                //"\"userHashCPF\":\""+checkEmptyData(userHashCPF)+"\","+
                //"\"userHashTel\":\""+checkEmptyData(userHashTel)+"\","+
                "\"advertisingId\":\""+checkEmptyData(advertisingId)+"\","+
                "\"tags\":\""+checkEmptyData(tags)+"\","+
                "\"latitude\":\""+checkEmptyData(latitude)+"\","+
                "\"longitude\":\""+checkEmptyData(longitude)+"\","+
                "\"language\":\""+checkEmptyData(language)+"\","+
                "\"timezone\":\""+checkEmptyData(timezone)+"\","+
                "\"os\":\""+checkEmptyData(os)+"\","+
                "\"apps\":\""+checkEmptyData(apps)+"\","+
                "\"brand\":\""+checkEmptyData(brand)+"\","+
                "\"product\":\""+checkEmptyData(product)+"\","+
                "\"device\":\""+checkEmptyData(device)+"\","+
                "\"hardware\":\""+checkEmptyData(hardware)+"\","+
                "\"manufacture\":\""+checkEmptyData(manufacture)+"\","+
                "\"model\":\""+checkEmptyData(model)+"\","+
                "\"lastrequest\":\""+checkEmptyData(lastrequest)+"\","+
                "\"carrierName\":\""+checkEmptyData(carrierName)+"\","+
                "\"accountID\":\""+checkEmptyData(accountID)+"\","+
                "\"activity\":\""+checkEmptyData(activity)+"\","+
                "\"lastLatitude\":\""+checkEmptyData(lastLatitude)+"\","+
                "\"lastLongitude\":\""+checkEmptyData(lastLongitude)+"\","+
                "\"currentApp\":\""+checkEmptyData(currentApp)+"\","+
                "\"errorList\":\""+checkEmptyData(errorList)+"\","+
                "\"tailSDKVersion\":\""+checkEmptyData(tailSDKVersion)+"\""+

                "}";

        return json;
    }
}
