package digital.tail.sdk.tail_mobile_sdk;

import android.app.IntentService;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.Gravity;
import android.widget.Toast;

import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

/**
 * Created by diego_saito on 7/17/17.
 */

public class TailDMPActivityTrackerIntentService extends IntentService {

    public TailDMPActivityTrackerIntentService(){
        super("TailDMPActivityTrackerIntentService");
    }

    public TailDMPActivityTrackerIntentService(String name){
        super(name);
    }


    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        if(ActivityRecognitionResult.hasResult(intent)) {
            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult(intent);
            handleDetectedActivities( result.getProbableActivities() );
        }
    }

    //broadcasts the message to our listener on ActivityTracker
    private void showMsg(String txt){
        // Initialize a new Intent object
        Intent intent = new Intent();
        // Set an action for the Intent
        intent.setAction("digital.tail.sdk.tail_mobile_sdk.USER_ACTIVITY");
        // Put an integer value Intent to broadcast it to TailDMPActivityTracker
        intent.putExtra("ACTIVITY_TYPE",txt);
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent);

    }

    private void handleDetectedActivities(List<DetectedActivity> probableActivities) {

        ArrayList<ActivityResult> detectedMap = new ArrayList<ActivityResult>();

        //Log.e( "ActivityRecogition", "+++++++++++++++++++ " );

        for( DetectedActivity activity : probableActivities ) {
            switch( activity.getType() ) {
                case DetectedActivity.IN_VEHICLE: {
                    //Log.e( TailDMP.TAG," ActivityRecogition In Vehicle: " + activity.getConfidence() );

                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("IN_VEHICLE",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.ON_BICYCLE: {
                    //Log.e( TailDMP.TAG, "ActivityRecogition On Bicycle: " + activity.getConfidence() );

                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("ON_BICYCLE",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.ON_FOOT: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition On Foot: " + activity.getConfidence() );

                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("ON_FOOT",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.RUNNING: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition Running: " + activity.getConfidence() );
                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("RUNNING",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.STILL: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition Still: " + activity.getConfidence() );
                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("STILL",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.TILTING: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition Tilting: " + activity.getConfidence() );
                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("TILTING",activity.getConfidence()));
                    }

                    break;
                }
                case DetectedActivity.WALKING: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition Walking: " + activity.getConfidence() );
                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("WALKING",activity.getConfidence()));
                    }


                    break;
                }
                case DetectedActivity.UNKNOWN: {
                    //Log.e(TailDMP.TAG, "ActivityRecogition Unknown: " + activity.getConfidence() );
                    if(activity.getConfidence() >75){
                        detectedMap.add(new ActivityResult("UNKNOWN",activity.getConfidence()));
                    }

                    break;
                }
            }
        }

        //if we get more than one predicition we sort the array on descendent order and get the first item that will be with the biggest confidence value
        if(detectedMap.size() >1){
            //order list
            Collections.sort(detectedMap, new Comparator<ActivityResult>() {
                @Override
                public int compare(ActivityResult o1, ActivityResult o2) {

                    /*
                    //ASC

                    if (o1.value < o2.value) {
                        return -1;
                    }
                    if (o1.value > o2.value) {
                        return 1;
                    }
                    return 0;
                    */

                    // DESC
                    if (o1.value < o2.value) {
                        return 1;
                    }
                    if (o1.value == o2.value) {
                        return 0;
                    }
                    return -1;
                }
            });
        }

        String datatoShow = "UNKNOWN";

        if (detectedMap.size()>0){
            datatoShow = detectedMap.get(0).name;
        }

        showMsg(datatoShow);

    }


    //private class object
    public class ActivityResult{

        ActivityResult(String name, int value){
            this.name = name;
            this.value = value;
        }
        public String name ="";
        public int value = 0;
    }

}
