package digital.tail.sdk.tail_mobile_sdk;


import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.Gravity;
import android.widget.Toast;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.ActivityRecognition;

import java.util.ArrayList;


/**
 * Created by diego_saito on 7/17/17.
 */

 class TailDMPActivityTracker implements GoogleApiClient.ConnectionCallbacks, GoogleApiClient.OnConnectionFailedListener{

    public GoogleApiClient mApiClient;
    public Context context;
    public  PendingIntent pendingIntent =null;
    public TailDMPActivityTarckerBroadcastReceiver receiver;



    //default value
    public  int TRACKING_PERIOD = TailDMPDb.DB_VALUE_UPDATE_JOB_15MINUTES;

    public int getTRACKING_PERIOD() {
        return TRACKING_PERIOD;
    }

    public void setTRACKING_PERIOD(int TRACKING_PERIOD) {

        //track activity 2 times between the given period
        this.TRACKING_PERIOD = TRACKING_PERIOD/2;
    }

    private TailDMPDeviceMapping deviceMapping;

    //constructor
    TailDMPActivityTracker(Context context,TailDMPDeviceMapping deviceMapping){
        if(context != null) {
            this.context = context;
            this.deviceMapping = deviceMapping;
            createClient();
            unregisterBroadcast();
            registerBroadcast();
        }
    }

    //initial setup
    public void createClient(){

        try {
            //creates a receiver
            if (receiver == null) {
                receiver = new TailDMPActivityTarckerBroadcastReceiver();
            }


            //connects to GoogleApiClient
            if (mApiClient == null) {
                mApiClient = new GoogleApiClient.Builder(this.context)
                        .addApi(ActivityRecognition.API)
                        .addConnectionCallbacks(this)
                        .addOnConnectionFailedListener(this)
                        .build();

                mApiClient.connect();
            }

        }catch(Exception e){
            e.printStackTrace();
        }

    }

    //register the message listener of our activitytracker
    public void registerBroadcast(){
        try {
            if (receiver != null) {
                LocalBroadcastManager.getInstance(context).registerReceiver(receiver, new IntentFilter("digital.tail.sdk.tail_mobile_sdk.USER_ACTIVITY"));
            }
        }catch(Exception e){
            e.printStackTrace();
        }

    }

    //unregister the message listener of our activitytracker
    public void unregisterBroadcast(){
        try {

            if (receiver != null) {
                LocalBroadcastManager.getInstance(context).unregisterReceiver(receiver);
            }
        }catch(Exception e){
            e.printStackTrace();
        }

    }


    public void stopActivityTracking(){
        try{
            Log.i(TailDMP.TAG,"ActivityTracker STOP Tracking Activity");
            if(mApiClient!= null && mApiClient.isConnected()) {

                ActivityRecognition.ActivityRecognitionApi.removeActivityUpdates(mApiClient, getActivityDetectionPendingIntent());
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }


    public void startActivityTracking(){

       try{
           if(mApiClient!= null && mApiClient.isConnected()){
               Log.i(TailDMP.TAG,"ActivityTracker - START Tracking Activity");
               //start to receive updates from activity API
               ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates( mApiClient, TRACKING_PERIOD, getActivityDetectionPendingIntent() );
           }else{

               Log.i(TailDMP.TAG,"Recreate ActivityTracker");

               //redo the iniital set up
               createClient();
               unregisterBroadcast();
               registerBroadcast();

               Log.i(TailDMP.TAG,"ActivityTracker - START Tracking Activity");
               //start to receive updates from activity API
               //ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates( mApiClient, TRACKING_PERIOD, getActivityDetectionPendingIntent() );
           }
       }catch(Exception e){
           e.printStackTrace();
       }


    }

    //returns always te same intent
    private PendingIntent getActivityDetectionPendingIntent() {
        Intent intent = new Intent(this.context, TailDMPActivityTrackerIntentService.class);

        // We use FLAG_UPDATE_CURRENT so that we get the same pending intent back when calling
        // requestActivityUpdates() and removeActivityUpdates().
        return PendingIntent.getService(this.context, TRACKING_PERIOD, intent, PendingIntent.FLAG_UPDATE_CURRENT);
    }


    @Override
    public void onConnected(@Nullable Bundle bundle) {
        Log.i(TailDMP.TAG,"ActivityTracker Connected!");


        //start activity tracker
        try{
            //creates a intent to be executed by ActivityRecognition process
            ActivityRecognition.ActivityRecognitionApi.requestActivityUpdates( mApiClient, TRACKING_PERIOD, getActivityDetectionPendingIntent() );

            Log.i(TailDMP.TAG,"ActivityTracker Start Tracking User Activity");

        }catch(Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void onConnectionSuspended(int i) {
        Log.i(TailDMP.TAG,"ActivityTracker Client Api connection suspended, trying to reconnect");

        try {
            //if we disconnect it for some reason, reconnect it
            mApiClient.connect();
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void onConnectionFailed(@NonNull ConnectionResult result) {
        Log.i(TailDMP.TAG, "ActivityTracker Connection failed: ConnectionResult erro code = " + result.getErrorCode());
    }

    //get the message from activity broadcaster
    protected void updateActivity(Intent broadcastedIntent){

        try{

            Bundle extradata = broadcastedIntent.getExtras();

            String activityType = "UNKNOWN";
            if(extradata != null) {
                activityType= extradata.getString("ACTIVITY_TYPE");
            }

            //get the database singleton
            TailDMPDb dbHelper = TailDMPDb.getInstance(context);
            dbHelper.updateActivity(activityType);

            //set the type of activity to devicemap to be saved later
            deviceMapping.setActivity(activityType);
        }catch (Exception e){
            e.printStackTrace();
        }

    }

    //Internal class to receive messages from activity tracker
    public class TailDMPActivityTarckerBroadcastReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            //call a method from ActivityTracker
            updateActivity(intent);
        }
    }


}
