package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by diego_saito on 5/10/17.
 */

 class TAsyncUpdateData extends AsyncTask<Map, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;

    public SQLiteDatabase db;

    public TAsyncUpdateData(SQLiteDatabase db){
        this.db = db;
    }

    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    @Override
    protected String doInBackground(Map... params) {

        Map data = params[0];

        String success = "not-success";

        if(hasDB() && db.isOpen()) {

            try {
                db.beginTransaction();

                ContentValues values = new ContentValues();
                Iterator entries = data.entrySet().iterator();

                //loop through our data
                while (entries.hasNext()) {

                    Map.Entry entry = (Map.Entry) entries.next();

                    String key = (String) entry.getKey();
                    String value = (String) entry.getValue();

                    //Log.d(TailDMPValues.TAG, "==> Valores para update = "+ key +":"+value);
                    if (!key.equals(TailDMPDb.DB_FIELD_LAST_REQUEST)) {

                        //don't add it if its value is null
                        if (value != null) {
                            boolean valempty = value.isEmpty();
                            //update data only if its not empty
                            if (!valempty) {
                                values.put(key, value);
                                //Log.d(TailDMPValues.TAG, "==> Valores inseridos apos tratar = "+ key +":"+value);
                            }
                        }
                    }
                }


                String lastrequest = new Date().getTime() + "";
                values.put(TailDMPDb.DB_FIELD_LAST_REQUEST, lastrequest);

                //update data of user 9999
                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);



                if (rows == 1) {
                    Log.i(TailDMPValues.TAG, "TAsyncUpdateData DB UPDATED");
                    success = "success";
                } else {
                    Log.i(TailDMPValues.TAG, "TAsyncUpdateData DB NOT UPDATED");

                }

                db.setTransactionSuccessful();
            } catch (Exception e) {
                Log.e(TailDMPValues.TAG, "Error while trying to add values to database" + e.getMessage());
            } finally {

                //try to end transaction
                if(hasDB() && db.isOpen()) {
                    try {
                        db.endTransaction();
                    }catch(Exception e){
                        e.printStackTrace();
                    }
                }

            }
        }else{
            Log.e(TailDMPValues.TAG, "Unable to update data, the database is unavailable");
        }

        return success;
    }

    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
    }
}
