package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import digital.tail.sdk.tail_mobile_sdk.TailDMPDb;
import digital.tail.sdk.tail_mobile_sdk.TailDMPValues;

/**
 * Created by diego_saito on 7/20/17.
 */

 class TAsyncUpdateActivity extends AsyncTask <Map, Void, String>{

    protected static final String TAG = TailDMPValues.TAG;

    public SQLiteDatabase db = null;

    public TAsyncUpdateActivity(SQLiteDatabase db){
        this.db = db;
    }


    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    @Override
    protected String doInBackground(Map... params) {

        Map data = params[0];

        if(db.isOpen()) {

            try {

                db.beginTransaction();
                //values to update
                ContentValues values = new ContentValues();

                //get the value of this object
                String actv = (String) data.get(TailDMPDb.DB_FIELD_ACTIVITY);

                // put the value on values object
                values.put(TailDMPDb.DB_FIELD_ACTIVITY, actv);

                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);
                if (rows == 1) {
                    // Log.i(TailDMPValues.TAG,TailDMPDb.DB_FIELD_ACTIVITY+" updated");
                } else {
                    //Log.i(TailDMPValues.TAG,TailDMPDb.DB_FIELD_ACTIVITY+" not updated");
                }

                db.setTransactionSuccessful();
            } catch (Exception e) {
                Log.e(TailDMPValues.TAG, "Error while trying to add values to database" + e.getMessage());
            } finally {
                if(hasDB() && db.isOpen()) {
                    db.endTransaction();
                }
            }
        }else{

            Log.e(TailDMPValues.TAG, "Error while trying to add activity values to database, the connection is closed" );
        }

        return null;
    }

    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
    }
}
