package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.util.Log;
import android.view.Gravity;
import android.widget.Toast;

import com.google.gson.Gson;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ConnectException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.google.gson.internal.bind.util.ISO8601Utils.format;

/**
 * Created by diego_saito on 8/8/17.
 */

 class TAsyncSendJSON extends AsyncTask<Object, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;

    protected static final int MAX_DATAITENS_PER_REQUEST = 20;

    public String str = "Empty";


    private String TAIL_API_ENDPOINT = "https://t.tailtarget.com/mobile";

    private Context context;

    private TailDMPDeviceMapping deviceMap;

    private TailDMP_Crypto crypto;

    //get the database singleton
    private TailDMPDb dbHelper = TailDMPDb.getInstance(context);
    //get database
    private SQLiteDatabase db = dbHelper.getdatabase();

    private boolean sendOnWIFIOnly = false;


    public TAsyncSendJSON(Context context, TailDMPDeviceMapping deviceMap) {

        this.context = context;
        this.deviceMap = deviceMap;

        //set URL sandbox or production
        TAIL_API_ENDPOINT = this.deviceMap.getEndPointURL();

        if(!TAIL_API_ENDPOINT.equals("https://t.tailtarget.com/mobile")){
            Log.e(TailDMPValues.TAG, "Warning!!! Sandbox Mode Enabled. Don't forget to disable sandbox mode before you publish the app on Google Play Store.");
        }


        crypto = new TailDMP_Crypto();
    }

    private boolean checkConnection() {

        ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        //wifi
        NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        //3g
        NetworkInfo mobileInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

        boolean mobileConnected = false;

        //when device don' have 3G, some tablets for example.
        if(mobileInfo != null ){
            mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;
        }


        boolean hasWifi = mWifi.isConnected();

        boolean hasconnection = false;

        //if user wants to send data only when we are using a wifi connection
        if(sendOnWIFIOnly){

            if (hasWifi) {
                hasconnection = true;
            }else{
                hasconnection = false;
            }

        }else{

            if (hasWifi) {
                hasconnection = true;
            }else{
                hasconnection = mobileConnected;
            }
        }

        return hasconnection;

    }


    private Map genereateHashDiff() {

        HashMap<String, String> mp = new HashMap<String, String>();
        for (int i = 0; i < TailDMPDb.dbfields.size(); i++) {
            mp.put(TailDMPDb.dbfields.get(i), "");
        }
        return mp;
    }

    private boolean isEmpty(String str) {
        if (str.isEmpty()) {
            return false;
        } else {
            return true;
        }
    }

    private String allErrors ="";

    private String null2EmptyStr(String str){

        if(str == "null" || str == null){
            return "";
        }else{
            return str;
        }
    }

    //send data to server
    private void sendRequest(TailDMPData data  ) {

        boolean errorOnServer = false;

        Map<String, String> mp = data.generateDataHash2Send();

        //creates json string to be sent and encrypt it
        String jsonToSend = crypto.generateEncryptedMessage(new Gson().toJson(mp));




       /*
       //debug long JSONs
       String pureJson = new Gson().toJson(mp);

        int maxLogSize = 1000;
        for(int i = 0; i <= pureJson.length() / maxLogSize; i++) {
            int start = i * maxLogSize;
            int end = (i+1) * maxLogSize;
            end = end > pureJson.length() ? pureJson.length() : end;
           // Log.d(TAG, pureJson.substring(start, end));
        }*/


        try {

            //adding accountID to url
            String urlEndpoint = TAIL_API_ENDPOINT + "?v=2&accountID=" + deviceMap.getAccountID();

            StringBuilder sb = new StringBuilder();

            URL url = new URL(urlEndpoint);

            Log.i(TailDMPValues.TAG, "==> Trying to send data to our server... Please, wait for a response");

            //URL connection
            HttpURLConnection urlConnection = null;

            urlConnection = (HttpURLConnection) url.openConnection();

            urlConnection.setConnectTimeout(TailDMPValues.TIMEOUT);
            urlConnection.setRequestMethod("POST");

            OutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            out.write(jsonToSend.getBytes());
            out.close();

            InputStream in = new BufferedInputStream(urlConnection.getInputStream());
            InputStream inputStream;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line;
            while ((line = r.readLine()) != null) {
                sb.append(line).append('\n');
            }

            Log.i(TailDMPValues.TAG, "<== Request sent to server! ");

            //close the reader
            r.close();

        } catch (FileNotFoundException e) {
            errorOnServer = true;
            e.printStackTrace();
            Log.i(TailDMPValues.TAG, "We can't send data to server, something wrong happened :( ");
        } catch (MalformedURLException e) {
            errorOnServer = true;
            e.printStackTrace();
            Log.i(TailDMPValues.TAG, "We can't send data to server, something wrong happened :( ");
        } catch (IOException e) {
            errorOnServer = true;
            e.printStackTrace();
            Log.i(TailDMPValues.TAG, "We can't send data to server, something wrong happened :( ");

        } finally {

            //-- >DEBUG
            //errorOnServer = false;

            if(!errorOnServer){
                if(mp.size()>0){

                    //All regs to be excluded
                    //we get the lastrequest field as key to identify all registers we want to exclude
                    String lstR = data.lastrequest.replace(";" , ",");

                    //clean up Qry
                    String qryDelete = "DELETE FROM "+TailDMPDb.DATABASE_TABLE_NAME +" WHERE "+ TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA +" AND "+TailDMPDb.DB_FIELD_LAST_REQUEST+ " IN ("+ lstR +");"  ;

                    try{
                        //delete all data of user 91553, all differences
                        Cursor delcursor = db.rawQuery(qryDelete,null);

                        int delCount = delcursor.getCount();

                        if(delcursor != null && !delcursor.isClosed()){
                            delcursor.close();
                        }

                    }catch(Exception e){
                        e.printStackTrace();
                    }


                    //Clean all errors
                    String cleanErrosQRY = "UPDATE " +TailDMPDb.DATABASE_TABLE_NAME   +" SET errorList = '' WHERE user_id = "+TailDMPDb.USER_ID;

                    if(!allErrors.isEmpty()){

                        ContentValues values = new ContentValues();
                        values.put(TailDMPDb.DB_FIELD_ERRORLIST , "");

                        try{

                            int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);
                            if (rows == 1) {
                                Log.i(TailDMPValues.TAG, "TAsyncSendALLJSON Data Updated");
                            } else {
                                Log.i(TailDMPValues.TAG, "TAsyncSendALLJSON Data Not Updated");
                            }

                            db.setTransactionSuccessful();
                            db.endTransaction();

                        }catch(Exception e){
                            e.printStackTrace();
                        }


                    }

                }

            }

        }


    }


    @Override
    protected String doInBackground(Object... params) {

        //Map map2Send = genereateHashDiff();
        str = "";

        int count = params.length;

        //get the database singleton
        TailDMPDb dbHelper = TailDMPDb.getInstance(context);
        //get database
        SQLiteDatabase db = null;



        //get the user data from our database to be sent by URL
        //TailDMPData dataDiff = new TailDMPData();

        /*************************
         *
         * Handling all user data
         *
         ************************/
        String intervalOfReq = "";

        Map<String, String> alluserData = new HashMap<String, String>();
        //select all data of user 9999
        //query database to check if there is an user
        String tailSDKVersion = "";

        //Save optin to use later
        boolean isoptin = false;

        String queryUsr = "SELECT * FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID + ";";

        Cursor cursor2 = null;
        int countUser = 0;

        try {

            db = dbHelper.getdatabase();
            cursor2 = db.rawQuery(queryUsr, null);
            countUser = cursor2.getCount();

            if (countUser > 0) {

                cursor2.moveToFirst();

                for (int i = 0; i < TailDMPDb.dbfields.size(); i++) {
                    alluserData.put(TailDMPDb.dbfields.get(i), cursor2.getString(cursor2.getColumnIndex(TailDMPDb.dbfields.get(i))));

                }

            }

        }catch(Exception e){
            e.printStackTrace();
        }finally {

            if (cursor2 != null && !cursor2.isClosed()) {
                cursor2.close();
            }
        }




        if(alluserData.get(TailDMPDb.DB_FIELD_OPTIN).equals("1")){
            isoptin = true;
        }else{
            isoptin = false;
        }


        if(alluserData.get(TailDMPDb.DB_FIELD_SEND_DATA_WIFIONLY).equals("1")){
            sendOnWIFIOnly = true;
        }else{
            sendOnWIFIOnly = false;
        }

        //save all errors for use later
        allErrors = alluserData.get(TailDMPDb.DB_FIELD_ERRORLIST);

        //save the version of our sdk to be sent to our servers
        tailSDKVersion = alluserData.get(TailDMPDb.DB_FIELD_TAIL_SDK_VERSION);

        //save the interval between requests to be printed on the end of this operation
        intervalOfReq = alluserData.get(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME);

        /*************************
         *
         * Handling only differences between last time data was collected
         *
         ************************/

        //select all data of user 91553, all differences
        String query = "SELECT * FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID_SEND_DATA + ";";

        Cursor cursor = null;

        int diffDataCount = 0;

        String time2update = "";
        ArrayList<TailDMPData> dataList = new ArrayList<TailDMPData>();


        try {
            cursor = db.rawQuery(query, null);

            diffDataCount = cursor.getCount();


            int idx = 0;

            TailDMPData listofData = null;

            if (cursor.moveToFirst()) {

                String lastLatIDX0 = "";
                String lastLongIDX0 = "";

                do {

                    String prefix = "";

                    //devide lists to send
                    if (idx % MAX_DATAITENS_PER_REQUEST == 0) {
                        //Log.i(TAG, "ADD: NEW LIST"+ idx);
                        listofData = new TailDMPData();
                        dataList.add(listofData);
                        idx = 0;
                    }

                    //add sufix to separate data
                    if (idx > 0) {
                        prefix = ";";
                    }

                    //save lastLat and lastLong of the first item
                    if(idx == 0){
                        lastLatIDX0 = null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLATITUDE)) );
                        lastLongIDX0 = null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLONGITUDE)) );

                    }

                    //listofData.latitude += sufix + cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE));

                    //concat all data and separate selected ones with prefix ';'
                    listofData.apiVersion           += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APIVERSION)) );
                    listofData.userHash             =  null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH)) );
                    listofData.userHashCPF          += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF)) );
                    listofData.userHashEmail        += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL)) );
                    listofData.userHashTel          += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL)) );
                    listofData.advertisingId        =  null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID)) );
                    listofData.tags                 += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TAGS)) );
                    listofData.latitude             += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE)) );
                    listofData.longitude            += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LONGITUDE)) );
                    listofData.language             += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LANGUAGE)) );
                    listofData.timezone             += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TIMEZONE)) );
                    listofData.os                   += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OS)) );
                    listofData.device               += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_DEVICE)) );
                    listofData.manufacture          += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MANUFACTURER)) );
                    listofData.model                += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MODEL)) );
                    listofData.hardware             += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_HARDWARE)) );
                    listofData.brand                += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_BRAND)) );
                    listofData.product              += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_PRODUCT)) );
                    listofData.apps                 += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS)) );
                    listofData.carrierName          += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CARRIER_NAME)) );
                    listofData.lastrequest          += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST)) );
                    listofData.accountID            =  null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID)) );
                    listofData.activity             += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACTIVITY)) );
                    //listofData.lastLatitude         += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLATITUDE)) );
                    //listofData.lastLongitude        += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLONGITUDE)) );
                    listofData.lastLatitude         = (lastLatIDX0.isEmpty())? "" : lastLatIDX0;
                    listofData.lastLongitude        = (lastLongIDX0.isEmpty())? "" : lastLongIDX0;
                    listofData.updateSendJobTime    += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME)) );
                    listofData.updateCollectJobTime += prefix + null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME)) );
                    listofData.currentApp           =  null2EmptyStr( cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CURRENTAPP)) );
                    listofData.tailSDKVersion       =  tailSDKVersion;
                    listofData.errorList            = allErrors;
                    time2update = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME));

                    idx++;

                } while (cursor.moveToNext());
            }

        } catch (Exception e) {
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database " + e.getMessage());
        } finally {

            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }

        }


        //if dont have changes send all data
        if (diffDataCount == 0) {
            //remove userhash not used
            //alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_CPF);
            //alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_TEL);
            //alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_EMAIL);

            TailDMPData t = new TailDMPData();
            t.populateTailDMPData(alluserData);
            dataList.add(t);
        }

        //Json to be sent
        String jsonToSend = "";

        //URL connection
        HttpURLConnection urlConnection = null;

        //just send data if we have connection and some data to be sent
        if (checkConnection() && dataList.size() > 0) {

            //send data if user is optin
            if(isoptin) {
                //send lists to server
                for (int i = 0; i < dataList.size(); i++) {
                    sendRequest(dataList.get(i));
                }
            }else{
                Log.e(TailDMP.TAG, "To send data to server the User must be optin.");
            }

        } else {

            if(sendOnWIFIOnly){
                Log.e(TailDMPValues.TAG,"We can't send data to server. No Wifi connection available");
            }else{
                Log.e(TailDMPValues.TAG,"We can't send data to server. No connection available");
            }

            //we must set the return empty for the next tags data check detect a change.
            // when the next iteration occurs and we have connection then we send the tags to be save on devicemap.
            str = "";
        }

        long a =  Integer.parseInt(intervalOfReq); //TailDMPDb.DB_VALUE_UPDATE_JOB_HOURLY;
        long b = new Date().getTime();

        Date date = new Date((a+b));
        DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        String nextrequest = formatter.format(date);

        Log.i(TailDMPValues.TAG,"==| End of operation - Waiting until next request call ...");
        Log.i(TailDMPValues.TAG, "If scheduled, we expect to send data again at: " + nextrequest );


        //return tags to be saved on device mapping by
        //onPostExecute() on TailDMPJobService.java
        return str;

    }

    @Override
    protected void onPostExecute(String resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncSendData - onPostExecute() result : "+ resultFromAsync);

    }
}