package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.util.Log;
import android.view.Gravity;
import android.widget.Toast;

import com.google.gson.Gson;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ConnectException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.google.gson.internal.bind.util.ISO8601Utils.format;

/**
 * Created by diego_saito on 5/11/17.
 */




 class TAsyncSendData extends AsyncTask<Object, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;

    public String str = "Empty";

    private String TAIL_API_ENDPOINT = "https://t.tailtarget.com/mobile";

    private Context context;

    private TailDMPDeviceMapping deviceMap;

    public TAsyncSendData(Context context, TailDMPDeviceMapping deviceMap){

        this.context = context;
        this.deviceMap = deviceMap;

        //set URL sandbox or production
        TAIL_API_ENDPOINT = this.deviceMap.getEndPointURL();

        if(!TAIL_API_ENDPOINT.equals("https://t.tailtarget.com/mobile")){
            Log.e(TailDMPValues.TAG, "Warning!!! Sandbox Mode Enabled. Don't forget to disable sandbox mode before you publish the app on Google Play Store.");
        }
    }

    private boolean checkConnection(){

        ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        //wifi
        NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        //3g
        NetworkInfo mobileInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

        boolean mobileConnected = false;

        //when device don' have 3G, some tablets for example.
        if(mobileInfo != null ){
            mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;
        }


        boolean hasWifi = mWifi.isConnected();

        if (hasWifi) {
            return true;
        }else{
            return mobileConnected;
        }

    }

    private String generateCompositeUserHash(String emailHash, String cpfHash, String telHash){

        String userhash2Send = "";

            if (emailHash != null && emailHash.length() >1){

                userhash2Send += ";"+emailHash;
            }
            if (cpfHash != null && cpfHash.length() >1){

                userhash2Send += ";"+cpfHash;
            }
            if (telHash != null && telHash.length() >1){

                userhash2Send += ";"+telHash;
            }

            if(userhash2Send.length() >0){
                userhash2Send = userhash2Send.substring(1);
            }

        return userhash2Send;

    }

    //compares data from DB to data of devicemapping
    private Map checkdataTosend(TailDMPData dataFromDB, TailDMPDeviceMapping dataFromDeviceMapping){


        Map<String,String> dataToUpdate = new HashMap<String, String>();

        //if there's data from DB compares with device mapping data
        if(dataFromDB !=null){
            //checking if the values of database and device mapping are equal

            if(!dataFromDB.apiVersion.equals(dataFromDeviceMapping.getApiVersion())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_APIVERSION      ,dataFromDeviceMapping.getApiVersion());
            }


            if(!dataFromDB.userHashTel.equals(dataFromDeviceMapping.getUserHashTel())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashTel() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashTelNotEncrypted(dataFromDB.userHashTel);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDB.userHashTel);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDeviceMapping.getUserHashTel());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDB.userHashTel);
            }

            if(!dataFromDB.userHashEmail.equals(dataFromDeviceMapping.getUserHashEmail())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashEmail() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashEmailNotEncrypted(dataFromDB.userHashEmail);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDB.userHashEmail);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDeviceMapping.getUserHashEmail());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDB.userHashEmail);
            }

            if(!dataFromDB.userHashCPF.equals(dataFromDeviceMapping.getUserHashCPF())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashCPF() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashCPFNotEncrypted(dataFromDB.userHashCPF);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDB.userHashCPF);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDeviceMapping.getUserHashCPF());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDB.userHashCPF);
            }

            if(!dataFromDB.advertisingId.equals(dataFromDeviceMapping.getAdvertisingId())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID      ,dataFromDeviceMapping.getAdvertisingId());
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID      ,dataFromDB.advertisingId);
            }


            String json = dataFromDeviceMapping.getTagsJSONFormated();

            //in this case we do the opposite of the rest of check, because the most recent data is the data of db and not the data of devicemap
            // we do this because tags can be added and removed in run time, we need that this data be persistent in foreground and background states, so we save it on data base
            if(dataFromDeviceMapping.getTagsJSONFormated() !=null && !dataFromDB.tags.equals(dataFromDeviceMapping.getTagsJSONFormated())){

                dataToUpdate.put(TailDMPDb.DB_FIELD_TAGS      , dataFromDB.tags);

            }


            if(dataFromDeviceMapping.getLatitude() != null && !dataFromDB.latitude.equals(dataFromDeviceMapping.getLatitude())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LATITUDE     ,dataFromDeviceMapping.getLatitude()+"");
                //the last latitude is the one that is saved in device DB
                dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLATITUDE     ,dataFromDB.latitude );

            }
            if(dataFromDeviceMapping.getLongitude() !=null && !dataFromDB.longitude.equals(dataFromDeviceMapping.getLongitude())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LONGITUDE    ,dataFromDeviceMapping.getLongitude()+"");
                //the last longitude is the one that is saved in device DB
                dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLONGITUDE  ,dataFromDB.longitude );
            }


            if(!dataFromDB.language.equals(dataFromDeviceMapping.getLanguage())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LANGUAGE     ,dataFromDeviceMapping.getLanguage());
            }
            if(!dataFromDB.timezone.equals(dataFromDeviceMapping.getTimezone())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE     ,dataFromDeviceMapping.getTimezone());
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE     ,dataFromDeviceMapping.getTimezone());
            }

            if(!dataFromDB.os.equals(dataFromDeviceMapping.getOs())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_OS     ,dataFromDeviceMapping.getOs());
            }
            if(!dataFromDB.apps.equals(dataFromDeviceMapping.getAppsJSONFormated())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_APPS     ,dataFromDeviceMapping.getAppsJSONFormated());
            }

            if(!dataFromDB.brand.equals(dataFromDeviceMapping.getBrand())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_BRAND     ,dataFromDeviceMapping.getBrand());
            }
            if(!dataFromDB.product.equals(dataFromDeviceMapping.getProduct())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_PRODUCT     ,dataFromDeviceMapping.getProduct());
            }
            if(!dataFromDB.device.equals(dataFromDeviceMapping.getDevice())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_DEVICE     ,dataFromDeviceMapping.getDevice());
            }
            if(!dataFromDB.hardware.equals(dataFromDeviceMapping.getHardware())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_HARDWARE     ,dataFromDeviceMapping.getHardware());
            }
            if(!dataFromDB.manufacture.equals(dataFromDeviceMapping.getManufacturer())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_MANUFACTURER     ,dataFromDeviceMapping.getManufacturer());
            }
            if(!dataFromDB.model.equals(dataFromDeviceMapping.getModel())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_MODEL     ,dataFromDeviceMapping.getModel());
            }

            if(!dataFromDB.carrierName.equals(dataFromDeviceMapping.getCarrierName())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_CARRIER_NAME     ,dataFromDeviceMapping.getCarrierName());
            }

            //Always send this data, its the current app that will run the SDK
            dataToUpdate.put(TailDMPDb.DB_FIELD_CURRENTAPP       ,dataFromDeviceMapping.getCurrentApp());

            String lastrequest = new Date().getTime()+"";
            dataToUpdate.put(TailDMPDb.DB_FIELD_LAST_REQUEST     ,lastrequest);
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACCOUNTID     ,dataFromDeviceMapping.getAccountID());

            //Sometimes the activity tracker is not available when we are sending data to server, so we get the last activity saved on DB a send it to server
            if(dataFromDeviceMapping.getActivity().isEmpty()){
                dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY     ,dataFromDB.activity);
            }else{
                dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY     ,dataFromDeviceMapping.getActivity());
            }


        }else{
            //return all device mapping data
            dataToUpdate.put(TailDMPDb.DB_FIELD_APIVERSION      ,dataFromDeviceMapping.getApiVersion());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF        ,dataFromDeviceMapping.getUserHashCPF());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL        ,dataFromDeviceMapping.getUserHashEmail());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL        ,dataFromDeviceMapping.getUserHashTel());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID   ,dataFromDeviceMapping.getAdvertisingId());
            dataToUpdate.put(TailDMPDb.DB_FIELD_TAGS            ,dataFromDeviceMapping.getTagsJSONFormated().trim());
            dataToUpdate.put(TailDMPDb.DB_FIELD_LATITUDE        ,dataFromDeviceMapping.getLatitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLATITUDE        ,dataFromDeviceMapping.getLastLatitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LONGITUDE       ,dataFromDeviceMapping.getLongitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLONGITUDE       ,dataFromDeviceMapping.getLastLongitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LANGUAGE        ,dataFromDeviceMapping.getLanguage());
            dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE        ,dataFromDeviceMapping.getTimezone());
            dataToUpdate.put(TailDMPDb.DB_FIELD_OS              ,dataFromDeviceMapping.getOs());
            dataToUpdate.put(TailDMPDb.DB_FIELD_APPS            ,dataFromDeviceMapping.getAppsJSONFormated());
            dataToUpdate.put(TailDMPDb.DB_FIELD_BRAND           ,dataFromDeviceMapping.getBrand());
            dataToUpdate.put(TailDMPDb.DB_FIELD_PRODUCT         ,dataFromDeviceMapping.getProduct());
            dataToUpdate.put(TailDMPDb.DB_FIELD_DEVICE          ,dataFromDeviceMapping.getDevice());
            dataToUpdate.put(TailDMPDb.DB_FIELD_HARDWARE        ,dataFromDeviceMapping.getHardware());
            dataToUpdate.put(TailDMPDb.DB_FIELD_MANUFACTURER    ,dataFromDeviceMapping.getManufacturer());
            dataToUpdate.put(TailDMPDb.DB_FIELD_MODEL           ,dataFromDeviceMapping.getModel());
            dataToUpdate.put(TailDMPDb.DB_FIELD_CARRIER_NAME    ,dataFromDeviceMapping.getCarrierName());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACCOUNTID       ,dataFromDeviceMapping.getAccountID());
            //Always send this data, its the current app that will run the SDK
            dataToUpdate.put(TailDMPDb.DB_FIELD_CURRENTAPP       ,dataFromDeviceMapping.getCurrentApp());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY      ,dataFromDeviceMapping.getActivity());

            String lastrequest = new Date().getTime()+"";
            dataToUpdate.put(TailDMPDb.DB_FIELD_LAST_REQUEST     ,lastrequest);


        }

        //generating hash to send

        //get all 3 types of hash
        String hashEmail = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_EMAIL);
        String hashCPF = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_CPF);
        String hashTel = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_TEL);

        //call method to concat hashes
        String hash2Send = generateCompositeUserHash(hashEmail, hashCPF, hashTel);

        //if we generate a new userHash we must set it to devicemap
        dataFromDeviceMapping.setUserHash(hash2Send);

        //add it to map
        dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH    ,hash2Send);

        return dataToUpdate;

    }

    @Override
    protected String doInBackground(Object... params) {


        str = "";

        TailDMP_Crypto crypto = new TailDMP_Crypto();

        int count = params.length;

        //get the database singleton
        TailDMPDb dbHelper = TailDMPDb.getInstance(context);

        //get the user data from our database to be sent by URL
        TailDMPData dataFromDB = new TailDMPData();

        String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";

        Cursor cursor = null;

        SQLiteDatabase db = null;

        try{
            //get database
            db = dbHelper.getdatabase();

            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                do {
                    dataFromDB.apiVersion = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APIVERSION));
                    dataFromDB.userHashCPF = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF));
                    dataFromDB.userHashEmail = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL));
                    dataFromDB.userHashTel = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL));
                    dataFromDB.advertisingId = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID));
                    dataFromDB.tags = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TAGS));
                    dataFromDB.latitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE));
                    dataFromDB.longitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LONGITUDE));
                    dataFromDB.language = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LANGUAGE));
                    dataFromDB.timezone = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TIMEZONE));
                    dataFromDB.os = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OS));
                    dataFromDB.device = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_DEVICE));
                    dataFromDB.manufacture = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MANUFACTURER));
                    dataFromDB.model = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MODEL));
                    dataFromDB.hardware = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_HARDWARE));
                    dataFromDB.brand = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_BRAND));
                    dataFromDB.product = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_PRODUCT));
                    dataFromDB.apps = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS));
                    dataFromDB.carrierName = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CARRIER_NAME));
                    dataFromDB.lastrequest = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));
                    dataFromDB.accountID = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID));
                    dataFromDB.activity = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACTIVITY));
                    dataFromDB.lastLatitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLATITUDE));
                    dataFromDB.lastLongitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLONGITUDE));
                    dataFromDB.updateSendJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME));
                    dataFromDB.updateCollectJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME));

                } while(cursor.moveToNext());
            }

        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database "+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }

            //db.close();
        }

        //check if there's some data that has been changed to be transformed in json to be sent
        Map dt2send = checkdataTosend(dataFromDB, deviceMap);

        //Json to be sent
        String jsonToSend ="";

        //URL connection
        HttpURLConnection urlConnection = null;

        //just send data if we have connection and some data to be sent
        if(checkConnection() && dt2send.size() >0){

            //we create a copy of our datamap and discard all usershash but 'userHash'
            Map<String,String> dtWoutUserHashes = new HashMap<String, String>(dt2send);
            dtWoutUserHashes.remove(TailDMPDb.DB_FIELD_USERHASH_EMAIL);
            dtWoutUserHashes.remove(TailDMPDb.DB_FIELD_USERHASH_TEL);
            dtWoutUserHashes.remove(TailDMPDb.DB_FIELD_USERHASH_CPF);

            //creates json string to be sent and encrypt it
            jsonToSend = crypto.generateEncryptedMessage(new Gson().toJson(dtWoutUserHashes));

            //Log.i(TailDMPValues.TAG,"SENDING JSON "+new Gson().toJson(dtWoutUserHashes));
            //Log.i(TailDMPValues.TAG, "JSON CRIPTO "+jsonToSend);

            StringBuilder sb = new StringBuilder();

            boolean errorOnServer = false;
            try {
                //adding accountID to url
                String urlEndpoint = TAIL_API_ENDPOINT+"?v=2&accountID="+deviceMap.getAccountID();

                //Log.i(TailDMPValues.TAG,"URL POST"+urlEndpoint);

                URL url = new URL(urlEndpoint);


                Log.i(TailDMPValues.TAG,"==> Trying to send data to our server... Please, wait for a response");

                urlConnection = (HttpURLConnection) url.openConnection();

                urlConnection.setConnectTimeout(TailDMPValues.TIMEOUT);
                urlConnection.setRequestMethod("POST");

                OutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
                out.write(jsonToSend.getBytes());
                out.close();

                InputStream in = new BufferedInputStream(urlConnection.getInputStream());
                InputStream inputStream;
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String line;
                while ((line = r.readLine()) != null) {
                    sb.append(line).append('\n');
                }


                Log.i(TailDMPValues.TAG, "<== Request sent to server! " );

                //close the reader
                r.close();

            } catch (FileNotFoundException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( ");
            } catch (MalformedURLException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( " );
            } catch (IOException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( " );

            }finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();


                    //save data to send later
                    dbHelper.saveDataForLater(dt2send);

                    //if there is some data to be sent and there's no error

                    if(dt2send != null && !errorOnServer) {
                    //==>> DEBUG
                    //if(dt2send != null) {
                        //update db
                        //dbHelper.updateData(dt2send);
                        //return tags to be saved on device mapping object in TailDMPJobService Class
                        str = dataFromDB.tags;
                    }else{


                    }


                    //Stop activity
                    //reset time to start activity ex: (time until next job - time until next job / 3 )
                    //Restart activity

                    long a = Integer.parseInt(dataFromDB.updateSendJobTime);
                    long b = new Date().getTime();

                    Date date = new Date((a+b));
                    DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
                    String nextrequest = formatter.format(date);


                    Log.i(TailDMPValues.TAG,"==| End of operation - Waiting until next request call ...");
                    Log.i(TailDMPValues.TAG, "If scheduled, we expect to run next job at: " + nextrequest );
                }
            }

            //return sb.toString();


        }else{
            Log.e(TailDMPValues.TAG,"We can't send data to server. No connection available");
            //we must set the return empty for the next tags data check detect a change.
            // when the next iteration occurs and we have connection then we send the tags to be save on devicemap.
            str = "";
        }
        //return tags to be saved on device mapping by
        //onPostExecute() on TailDMPJobService.java
        return str;

    }

    @Override
    protected void onPostExecute(String resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncSendData - onPostExecute() result : "+ resultFromAsync);

    }
}
