package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.renderscript.Sampler;
import android.util.Log;

import com.google.gson.Gson;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by diego_saito on 8/9/17.
 */

class TAsyncSendALLJSON extends AsyncTask<Object, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;

    public String str = "Empty";

    //private final String TAIL_API_ENDPOINT = "http://192.168.11.49:8080/api/v2/dmp";
    private String TAIL_API_ENDPOINT = "https://t.tailtarget.com/mobile";
//    private final String TAIL_API_ENDPOINT = "http://192.168.11.49:8888/api/v2/sandbox/mobile";

    // SANDBOX HLG
   // private final String TAIL_API_ENDPOINT = "https://hlg-api.tailtarget.com/api/v2/sandbox/mobile";

    // SANDBOX PROD - UTILIZAR ESSE
//    private final String TAIL_API_ENDPOINT = "https://api.tailtarget.com/api/v2/sandbox/mobile";


    private Context context;

    private TailDMPDeviceMapping deviceMap;

    private boolean sendOnWIFIOnly = false;

    public boolean sendtag = false;
    public String tagToSend = "";

    public TAsyncSendALLJSON(Context context, TailDMPDeviceMapping deviceMap){

        this.context = context;
        this.deviceMap = deviceMap;

        //set URL sandbox or production
        TAIL_API_ENDPOINT = this.deviceMap.getEndPointURL();

        if(!TAIL_API_ENDPOINT.equals("https://t.tailtarget.com/mobile")){
            Log.e(TailDMPValues.TAG, "Warning!!! Sandbox Mode Enabled. Don't forget to disable sandbox mode before you publish the app on Google Play Store.");
        }
    }

    private boolean checkConnection(){

        ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        //wifi
        NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        //3g
        NetworkInfo mobileInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

        boolean mobileConnected = false;

        //when device don' have 3G, some tablets for example.
        if(mobileInfo != null ){
            mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;
        }


        boolean hasWifi = mWifi.isConnected();


        boolean hasconnection = false;
        //if user wants to send data only when we are using a wifi connection
        if(sendOnWIFIOnly){

            if (hasWifi) {
                hasconnection = true;
            }else{
                hasconnection = false;
            }

        }else{

            if (hasWifi) {
                hasconnection = true;
            }else{
                hasconnection = mobileConnected;
            }
        }




        return hasconnection;


    }


    private Map genereateHashDiff (){

        HashMap<String,String> mp = new HashMap<String, String>();
        for(int i = 0; i<TailDMPDb.dbfields.size(); i++){
            mp.put(TailDMPDb.dbfields.get(i),"");
        }
        return mp;
    }

    private boolean isEmpty(String str){
        if (str.isEmpty()){
            return false;
        }else{
            return true;
        }
    }

    private SQLiteDatabase db = null;

    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    @Override
    protected String doInBackground(Object... params) {

        str = "";

        TailDMP_Crypto crypto = new TailDMP_Crypto();

        //get the database singleton
        TailDMPDb dbHelper = TailDMPDb.getInstance(context);
        //get database



        /*************************
         *
         * Handling all user data
         *
         ************************/

        Map <String,String> alluserData = new HashMap<String,String>();

        int countUser = 0;

        //Save optin to use later
        boolean isoptin = false;

        //Map to be sent to server
        Map dt2send = null;

        //== > DEBUG
        //dbHelper.getdatabase().close();

        try {

            db = dbHelper.getdatabase();

            db.beginTransaction();
            //select all data of user 9999
            //query database to check if there is an user
            String queryUsr = "SELECT * FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID + ";";
            Cursor cursor2 = db.rawQuery(queryUsr, null);
            countUser = cursor2.getCount();

            if(countUser>0){

                cursor2.moveToFirst();
                for(int i = 0; i<TailDMPDb.dbfields.size(); i++){

                    alluserData.put(TailDMPDb.dbfields.get(i),cursor2.getString(cursor2.getColumnIndex(TailDMPDb.dbfields.get(i))));
                }

                if(cursor2 != null && !cursor2.isClosed()){
                    cursor2.close();
                }

            }

            //if LAT/LONG is empty get this data from devicemap
            if(alluserData.get(TailDMPDb.DB_FIELD_LATITUDE).isEmpty()){
                if(deviceMap.getLatitude() == null){
                    alluserData.put(TailDMPDb.DB_FIELD_LATITUDE,"");
                }else{
                    alluserData.put(TailDMPDb.DB_FIELD_LATITUDE,deviceMap.getLatitude()+"");
                }

            }

            if(alluserData.get(TailDMPDb.DB_FIELD_LONGITUDE).isEmpty()){

                if(deviceMap.getLatitude() == null){
                    alluserData.put(TailDMPDb.DB_FIELD_LONGITUDE,"");
                }else{
                    alluserData.put(TailDMPDb.DB_FIELD_LONGITUDE,deviceMap.getLongitude()+"");
                }
            }


            if(alluserData.get(TailDMPDb.DB_FIELD_OPTIN).equals("1")){
                isoptin = true;
            }else{
                isoptin = false;
            }


            //if user has defined to send data only with wifi connection
            if(alluserData.get(TailDMPDb.DB_FIELD_SEND_DATA_WIFIONLY).equals("1")){
                sendOnWIFIOnly = true;
            }else{
                sendOnWIFIOnly = false;
            }


            //remove userhash and data not used
            alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_CPF);
            alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_TEL);
            alluserData.remove(TailDMPDb.DB_FIELD_USERHASH_EMAIL);
            alluserData.remove(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME);
            alluserData.remove(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME);
            alluserData.remove(TailDMPDb.DB_FIELD_USER_ID);
            alluserData.remove(TailDMPDb.DB_FIELD_OPTIN);
            alluserData.remove(TailDMPDb.DB_FIELD_SEND_DATA_WIFIONLY);


            if(!sendtag){
                //we send tags in this call only if used by sendDirect function
                alluserData.put(TailDMPDb.DB_FIELD_TAGS, "");
            }else{
                alluserData.put(TailDMPDb.DB_FIELD_TAGS, tagToSend);
            }

            dt2send = alluserData;


        }catch(Exception e){
            e.printStackTrace();
        }


        //Json to be sent
        String jsonToSend ="";

        //URL connection
        HttpURLConnection urlConnection = null;


        //just send data if we have connection and some data to be sent
        if(checkConnection() && (dt2send !=null && dt2send.size() >0)){

            //creates json string to be sent and encrypt it
            jsonToSend = crypto.generateEncryptedMessage(new Gson().toJson(dt2send));


            StringBuilder sb = new StringBuilder();

            boolean errorOnServer = false;

            try {
                //adding accountID to url
                String urlEndpoint = TAIL_API_ENDPOINT+"?v=2&accountID="+deviceMap.getAccountID();

                URL url = new URL(urlEndpoint);

                Log.i(TailDMPValues.TAG,"==> Trying to send data to our server... Please, wait for a response");

                if(isoptin){

                    //Log.e(TailDMPValues.TAG,"+++ ALL SENDING JSON "+new Gson().toJson(dt2send));

                    urlConnection = (HttpURLConnection) url.openConnection();
                    urlConnection.setConnectTimeout(TailDMPValues.TIMEOUT);
                    urlConnection.setRequestMethod("POST");

                    OutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
                    out.write(jsonToSend.getBytes());
                    out.close();

                    InputStream in = new BufferedInputStream(urlConnection.getInputStream());
                    InputStream inputStream;
                    BufferedReader r = new BufferedReader(new InputStreamReader(in));
                    String line;
                    while ((line = r.readLine()) != null) {
                        sb.append(line).append('\n');
                    }

                    Log.i(TailDMPValues.TAG, "<== Request sent to server! " );

                    //close the reader
                    r.close();

                }else{
                    Log.e(TailDMP.TAG, "To send All data to server the User must  opt in.");
                }

            } catch (FileNotFoundException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( ");
            } catch (MalformedURLException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( " );
            } catch (IOException e) {
                errorOnServer = true;
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :( " );

            }finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();

                    long a =  TailDMPDb.DB_VALUE_UPDATE_JOB_ALLDATA; //TailDMPDb.DB_VALUE_UPDATE_JOB_HOURLY;
                    long b = new Date().getTime();

                    Date date = new Date((a+b));
                    DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
                    String nextrequest = formatter.format(date);

                    Log.i(TailDMPValues.TAG, "End of operation, if scheduled, we expect to send ALL data again at: " + nextrequest );

                    if(!errorOnServer){
                        //update last request

                        ContentValues values = new ContentValues();

                        //save the last request timestamp to user 99999
                        String lastrequest = new Date().getTime() + "";
                        values.put(TailDMPDb.DB_FIELD_LAST_REQUEST, lastrequest);

                        //values reset errors col
                        values.put(TailDMPDb.DB_FIELD_ERRORLIST, "");

                        try {
                            int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);
                            if (rows == 1) {
                                Log.i(TailDMPValues.TAG, "TAsyncSendALLJSON Data Updated");
                            } else {
                                Log.i(TailDMPValues.TAG, "TAsyncSendALLJSON Data Not Updated");
                            }
                        }catch(Exception e){
                            e.printStackTrace();
                        }



                    }

                }
            }

            //close transaction
            if(hasDB() && db.isOpen()) {

                try {
                    db.setTransactionSuccessful();
                    db.endTransaction();
                }catch(Exception e){
                    e.printStackTrace();
                }

            }

        }else{

            //close transaction
            if(hasDB() && db.isOpen()) {

                try {
                    db.setTransactionSuccessful();
                    db.endTransaction();
                }catch (Exception e){
                    e.printStackTrace();
                }

            }else{
                Log.e(TailDMPValues.TAG,"Unable to update data, the database is unavailable");
            }

            if(sendOnWIFIOnly){
                Log.e(TailDMPValues.TAG,"We can't send All data to server. No Wifi connection available");
            }else{
                Log.e(TailDMPValues.TAG,"We can't send All data to server. Unavailable service");
            }


            //we must set the return empty for the next tags data check detect a change.
            // when the next iteration occurs and we have connection then we send the tags to be save on devicemap.
            str = "";
        }
        //return tags to be saved on device mapping by
        //onPostExecute() on TailDMPJobService.java
        return str;

    }

    @Override
    protected void onPostExecute(String resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncSendData - onPostExecute() result : "+ resultFromAsync);

    }
}