package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by diego_saito on 3/26/18.
 */

public class TAsyncSaveErrorList extends AsyncTask<Map, Void, String> {

    private Context context;

    private String errorID;
    public TAsyncSaveErrorList (Context context, String errorID){
        this.context = context;
        this.errorID = errorID;
    }



    protected static final String TAG = TailDMPValues.TAG;

    public SQLiteDatabase db;

    @Override
    protected String doInBackground(Map... params) {
        Map data = params[0];

        String success = "not-success";


        //get the database singleton
        TailDMPDb dbHelper = TailDMPDb.getInstance(context);
        //get database
        SQLiteDatabase db = null;

        //get data from USER 9999
        String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";

        Cursor cursor = null;

        String listOfErrorsFromDB = "";

        ContentValues values = new ContentValues();

        try{

            db = dbHelper.getdatabase();

            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                listOfErrorsFromDB = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ERRORLIST));
            }

            //get saved list from DB and concat with new value
            listOfErrorsFromDB += errorID+";" ;

            //put this val into a map of Values
            values.put(TailDMPDb.DB_FIELD_ERRORLIST, listOfErrorsFromDB);


        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get Errolist from database "+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }


        }


        if(db.isOpen()) {


            try {

                db.beginTransaction();
                //update data of user 9999
                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);
                if (rows == 1) {
                    Log.i(TailDMPValues.TAG, "ERRO LIST UPDATED");
                    success = "success";
                } else {
                    Log.i(TailDMPValues.TAG, "ERRO LIST UPDATED");

                }

                db.setTransactionSuccessful();

            }catch (Exception e) {
                Log.e(TailDMPValues.TAG, "Error while trying to add Errolist to database" + e.getMessage());
            } finally {
                if(db != null) {
                    db.endTransaction();
                }
                //db.close();
            }



        }


        return success;
    }

    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
    }



}
