package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import java.util.ArrayList;
import java.util.Map;

/**
 * Created by diego_saito on 8/4/17.
 */

 class TAsyncSaveDataToSendLater extends AsyncTask<Map, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;
    protected static final int MAX_COLLECTED_DATAITENS = 4;

    public SQLiteDatabase db;

    public TAsyncSaveDataToSendLater(SQLiteDatabase db){
        this.db = db;
    }

    @Override
    protected String doInBackground(Map... params) {


        try{

            db.beginTransaction();
            //data sent
            Map dt2save = params[0];

            ContentValues values = new ContentValues();

            ContentValues values2update = new ContentValues();

            //all fields of db
            ArrayList <String> dbfields = TailDMPDb.dbfields;

            //remove these fields we are not handling then
            dbfields.remove(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME);
            dbfields.remove(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME);

            //loop through db keys

            for (int i =0; i<dbfields.size(); i++) {

                //if we don' have this key add it to data to be saved on db with an empty value
                if(!dt2save.containsKey(dbfields.get(i))){

                    //add the value of USER_ID_SEND_DATA to user_id field
                    if(i == 0){
                        values.put(dbfields.get(i),TailDMPDb.USER_ID_SEND_DATA);
                    }else{
                        values.put(dbfields.get(i),"");
                    }
                }else{
                    //there is a key and a value on dt2save, save it to our values var
                    String val = dt2save.get(dbfields.get(i)).toString();
                    values.put(dbfields.get(i),val);
                    values2update.put(dbfields.get(i),val);

                }

            }


            String qryCount = "SELECT COUNT(*) FROM "+TailDMPDb.DATABASE_TABLE_NAME+" WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA;
            Cursor cursor = db.rawQuery(qryCount,null);
            cursor.moveToFirst();
            int count= cursor.getInt(0);
            cursor.close();



            if(count <= MAX_COLLECTED_DATAITENS){

                //rowid of data inserted
                long result = -1;
                //insert data to user 91553
                result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, values);


                //update data in user 9999
                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values2update, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);

                db.setTransactionSuccessful();

                //Log.d(TailDMP.TAG,"USER DATA ADDED TO DB "+result);

            }else{

                //select the oldest row ordered by the time it was collected
                String qrySelectOldest = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+" WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA+ " ORDER BY "+TailDMPDb.DB_FIELD_LAST_REQUEST+ " ASC LIMIT 1";
                Cursor cursor2 = db.rawQuery(qrySelectOldest,null);

                //Oldest timestamp
                String lr ="";

                     while(cursor2.moveToNext()){
                         //get the timestamp of oldest data entry
                         lr = cursor2.getString(cursor2.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));

                    }
                //close cursor
                cursor2.close();

                //Exclude the oldest data
                String qryExcludeOldest = "DELETE FROM "+TailDMPDb.DATABASE_TABLE_NAME+" WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA+" AND " +TailDMPDb.DB_FIELD_LAST_REQUEST+" = "+lr;

                db.execSQL(qryExcludeOldest);

                //insert the new data

                //rowid of data inserted
                long result = -1;

                //insert data on user 91553
                result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, values);

                //update data in user 9999
                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values2update, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);

                db.setTransactionSuccessful();

                //Log.d(TailDMP.TAG,"EXCLUDED OLDEST DATA AND ADDED A NEW ONE TO DB "+result);

            }


        }catch (Exception e) {
            Log.e(TailDMPValues.TAG, "TAsyncSaveDataToSendLater - Error while trying to add values to database"+e.getMessage());
        } finally {
            if (db != null && db.isOpen()) {
                db.endTransaction();
            }
            //db.close();
        }

        return "";
    }


    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
    }
}
