package digital.tail.sdk.tail_mobile_sdk;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

import digital.tail.sdk.tail_mobile_sdk.exception.TailDMPException;


/**
 * Created by diego_saito on 5/8/17.
 */

 class TAsyncOperation extends AsyncTask <Object, Void, String>{

    protected static final String TAG = TailDMPValues.TAG;

    public String str = "Empty";

    private final String URL_REQ = "http://www.google.com";
    private final String TAIL_API_ENDPOINT = "https://t.tailtarget.com/mobile";

    private Context context;



    public TAsyncOperation(Context context){
        this.context = context;
    }


    private boolean checkConnection(){

        boolean mobileConnected = false;

        try {
            ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

            //wifi
            NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

            //3g
            NetworkInfo mobileInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

            mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;

            if (mWifi.isConnected()) {
                mobileConnected =  true;
            }

        }catch(Exception e){
            e.printStackTrace();
        }

        return mobileConnected;
    }


    @Override
    protected String doInBackground(Object... params) {

        //Log.i(TAG,"TAsyncOperation - doInBackground() : ");
        str = "String from doInBackground";

        int count = params.length;

        String jsonToSend = "";

        try {
            //get the database singleton
            TailDMPDb db = TailDMPDb.getInstance(context);
            //get the user data to send by URL
            TailDMPData dataFromDB = db.getUserData();

            if (dataFromDB != null) {
                //prepare data to be send
                jsonToSend = dataFromDB.toJson();
            }

        }catch(Exception e){
            e.printStackTrace();
        }


        HttpURLConnection urlConnection = null;

        if(checkConnection() && !jsonToSend.isEmpty()){
            

            StringBuilder sb = new StringBuilder();

            try {

                URL url = new URL(TAIL_API_ENDPOINT);

                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setConnectTimeout(TailDMPValues.TIMEOUT);
                urlConnection.setRequestMethod("POST");

                OutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
                out.write(jsonToSend.getBytes());
                out.close();

                InputStream in = new BufferedInputStream(urlConnection.getInputStream());
                InputStream inputStream;
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String line;
                while ((line = r.readLine()) != null) {
                    sb.append(line).append('\n');
                }

            } catch (FileNotFoundException e) {
                e.printStackTrace();
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }

            return sb.toString();


        }else{
            Log.e(TailDMPValues.TAG,"Can't send data to server. No connection available");
        }

        return str;
    }

    @Override
    protected void onPostExecute(String resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncOperation - onPostExecute() result : "+ resultFromAsync);

    }


}
