package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by diego_saito on 5/10/17.
 */

 class TAsyncGetUserData extends AsyncTask<Object, Void, TailDMPData> {

    protected static final String TAG = TailDMPValues.TAG;

    public SQLiteDatabase db;

    public TAsyncGetUserData(SQLiteDatabase db){
        this.db = db;
        //Log.d(TAG,"TAsyncGetUserData - INITIALIZE");

    }


    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    @Override
    protected TailDMPData doInBackground(Object... params) {



        TailDMPData userdata = new TailDMPData();

        String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";

        Cursor cursor = null;

        try{

            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                do {
                    userdata.apiVersion = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APIVERSION));
                    userdata.userHash = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH));
                    userdata.userHashCPF = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF));
                    userdata.userHashTel = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL));
                    userdata.userHashEmail = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL));
                    userdata.advertisingId = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID));
                    userdata.tags = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TAGS));
                    userdata.latitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE));
                    userdata.longitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LONGITUDE));
                    userdata.language = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LANGUAGE));
                    userdata.timezone = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TIMEZONE));
                    userdata.os = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OS));
                    userdata.device = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_DEVICE));
                    userdata.manufacture = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MANUFACTURER));
                    userdata.model = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MODEL));
                    userdata.hardware = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_HARDWARE));
                    userdata.brand = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_BRAND));
                    userdata.product = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_PRODUCT));
                    userdata.apps = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS));
                    userdata.carrierName = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CARRIER_NAME));
                    userdata.lastrequest = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));
                    userdata.accountID = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID));
                    userdata.currentApp = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CURRENTAPP));
                    userdata.activity = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACTIVITY));
                    userdata.updateCollectJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME));
                    userdata.updateSendJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME));
                    userdata.tailSDKVersion = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TAIL_SDK_VERSION));
                    userdata.sendDataWifiOnly = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_SEND_DATA_WIFIONLY));
                    userdata.optin = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OPTIN));

                } while(cursor.moveToNext());
            }

        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database"+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }



        return userdata;
    }

    @Override
    protected void onPostExecute(TailDMPData resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncGetUserData - onPostExecute() result : "+ resultFromAsync);

    }


}
