package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by diego_saito on 5/22/17.
 */

public class TAsyncGetClientData extends AsyncTask <String, Void, String>{

    private Context context;

    public String TAIL_API_CLIENT_ENDPOINT = "http://192.168.11.49:8080/api/v2/dmp";

    public TAsyncGetClientData(Context context){
        this.context = context;
    }

    //must be set to send back results to Activity
    public ITAsyncResponse delegate = null;

    private boolean checkConnection(){

        ConnectivityManager connManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        //wifi
        NetworkInfo mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI);

        //3g
        NetworkInfo mobileInfo = connManager.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

        boolean mobileConnected = mobileInfo.getState() == NetworkInfo.State.CONNECTED;

        boolean hasWifi = mWifi.isConnected();

        if (hasWifi) {
            return true;
        }else{
            return mobileConnected;
        }

    }


    @Override
    protected String doInBackground(String... params) {
        HttpURLConnection urlConnection = null;

        //get the database singleton
        TailDMPDb dbHelper = TailDMPDb.getInstance(context);
        //get database
        SQLiteDatabase db = null;

        //get the user data from our database to be sent by URL
        TailDMPData dataFromDB = new TailDMPData();

        String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";

        Cursor cursor = null;


        try{

            db = dbHelper.getdatabase();

            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                do {
                    dataFromDB.userHashTel = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL));
                    dataFromDB.userHashCPF = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF));
                    dataFromDB.userHashEmail = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL));

                    dataFromDB.advertisingId = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID));
                    dataFromDB.accountID = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID));
                } while(cursor.moveToNext());
            }

        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database"+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }

            //db.close();
        }




        //result of request
        String jsonResult ="";

        //json to be sent
        String jsonToSend = "{" +
                "\"userHashTel\" : \"" +dataFromDB.userHashTel+"\","+
                "\"userHashCPF\" : \"" +dataFromDB.userHashCPF+"\","+
                "\"userHashEmail\" : \"" +dataFromDB.userHashEmail+"\","+
                "\"advertisingId\" : \"" +dataFromDB.advertisingId+"\","+
                "\"accountID\" : \"" +dataFromDB.accountID+"\""+
                "}";

        if(checkConnection()) {

            Log.i(TailDMPValues.TAG,"Trying to get client data, please wait for response...");

            StringBuilder sb = new StringBuilder();

            try {

                URL url = new URL(TAIL_API_CLIENT_ENDPOINT);

                urlConnection = (HttpURLConnection) url.openConnection();
                //TODO: remover timeout
                urlConnection.setConnectTimeout(TailDMPValues.TIMEOUT);
                urlConnection.setRequestMethod("POST");

                OutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
                out.write(jsonToSend.getBytes());
                out.close();

                InputStream in = new BufferedInputStream(urlConnection.getInputStream());
                InputStream inputStream;
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String line;
                while ((line = r.readLine()) != null) {
                    sb.append(line).append('\n');
                }

            } catch (FileNotFoundException e) {
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :(");
            } catch (MalformedURLException e) {
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :(");
            } catch (IOException e) {
                e.printStackTrace();
                Log.i(TailDMPValues.TAG,"We can't send data to server, something wrong happened :(");
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                    jsonResult = sb.toString();

                }
            }

        }else{
            Log.e(TailDMPValues.TAG,"Can't send data to server. No connection available");
        }

        return jsonResult;
    }

    @Override
    protected void onPostExecute(String s) {
        //super.onPostExecute(s);
        if(delegate != null){
            delegate.asyncresult(s);
        }else{
            Log.e(TailDMP.TAG, "You must assign a delegate object to TAsyncGetClientData");
        }

    }
}
