package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by diego_saito on 8/4/17.
 */

 class TAsyncCollectData extends AsyncTask<Object, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;
    protected static final int MAX_COLLECTED_DATAITENS = 50;


    public String str = "Empty";

    private Context context;

    private TailDMPDeviceMapping deviceMap;

    public TAsyncCollectData(Context context, TailDMPDeviceMapping deviceMap){

        this.context = context;
        this.deviceMap = deviceMap;

    }

    private boolean checkConnection(){
        return true;
    }

    private String generateCompositeUserHash(String emailHash, String cpfHash, String telHash){

        String userhash2Send = "";

        if(emailHash != null && cpfHash != null && telHash != null){


            if (emailHash.length() >1){

                userhash2Send += ";"+emailHash;
            }
            if (cpfHash.length() >1){

                userhash2Send += ";"+cpfHash;
            }
            if (telHash.length() >1){

                userhash2Send += ";"+telHash;
            }

            if(userhash2Send.length() >0){
                userhash2Send = userhash2Send.substring(1);
            }



        }

        return userhash2Send;

    }

    //compares data from DB to data of devicemapping
    private Map checkdataTosend(TailDMPData dataFromDB, TailDMPDeviceMapping dataFromDeviceMapping){


        Map<String,String> dataToUpdate = new HashMap<String, String>();

        //if there's data from DB compares with device mapping data
        if(dataFromDB !=null){
            //checking if the values of database and device mapping are equal

            if(!dataFromDB.apiVersion.equals(dataFromDeviceMapping.getApiVersion())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_APIVERSION      ,dataFromDeviceMapping.getApiVersion());
            }


            if(!dataFromDB.userHashTel.equals(dataFromDeviceMapping.getUserHashTel())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashTel() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashTelNotEncrypted(dataFromDB.userHashTel);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDB.userHashTel);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDeviceMapping.getUserHashTel());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL      ,dataFromDB.userHashTel);
            }

            if(!dataFromDB.userHashEmail.equals(dataFromDeviceMapping.getUserHashEmail())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashEmail() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashEmailNotEncrypted(dataFromDB.userHashEmail);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDB.userHashEmail);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDeviceMapping.getUserHashEmail());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL      ,dataFromDB.userHashEmail);
            }

            if(!dataFromDB.userHashCPF.equals(dataFromDeviceMapping.getUserHashCPF())){
                //if userhash is null we must be on background process.
                // when the app goes to background, Android kills some of our object(like our device mapping) so we must to re insert the data
                if(dataFromDeviceMapping.getUserHashCPF() == null)
                {
                    //get the database user hash and add it to devicemapp
                    dataFromDeviceMapping.setUserHashCPFNotEncrypted(dataFromDB.userHashCPF);
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDB.userHashCPF);
                }else{
                    dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDeviceMapping.getUserHashCPF());
                }
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF      ,dataFromDB.userHashCPF);
            }

            if(!dataFromDB.advertisingId.equals(dataFromDeviceMapping.getAdvertisingId())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID      ,dataFromDeviceMapping.getAdvertisingId());
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID      ,dataFromDB.advertisingId);
            }


            String json = dataFromDeviceMapping.getTagsJSONFormated();

            //in this case we do the opposite of the rest of check, because the most recent data is the data of db and not the data of devicemap
            // we do this because tags can be added and removed in run time, we need that this data be persistent in foreground and background states, so we save it on data base
            /*if(dataFromDeviceMapping.getTagsJSONFormated() !=null && !dataFromDB.tags.equals(dataFromDeviceMapping.getTagsJSONFormated())){


                dataToUpdate.put(TailDMPDb.DB_FIELD_TAGS      , dataFromDB.tags);

            }*/

            dataToUpdate.put(TailDMPDb.DB_FIELD_TAGS      , "");


            if(dataFromDeviceMapping.getLatitude() != null && !dataFromDB.latitude.equals(dataFromDeviceMapping.getLatitude())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LATITUDE     ,dataFromDeviceMapping.getLatitude()+"");
                //the last latitude is the one that is saved in device DB
                dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLATITUDE     ,dataFromDB.latitude );

            }
            if(dataFromDeviceMapping.getLongitude() !=null && !dataFromDB.longitude.equals(dataFromDeviceMapping.getLongitude())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LONGITUDE    ,dataFromDeviceMapping.getLongitude()+"");
                //the last longitude is the one that is saved in device DB
                dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLONGITUDE  ,dataFromDB.longitude );
            }


            if(!dataFromDB.language.equals(dataFromDeviceMapping.getLanguage())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_LANGUAGE     ,dataFromDeviceMapping.getLanguage());
            }
            if(!dataFromDB.timezone.equals(dataFromDeviceMapping.getTimezone())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE     ,dataFromDeviceMapping.getTimezone());
            }else{
                //if they are equal send the value of Database, we always send this data
                dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE     ,dataFromDeviceMapping.getTimezone());
            }

            if(!dataFromDB.os.equals(dataFromDeviceMapping.getOs())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_OS     ,dataFromDeviceMapping.getOs());
            }



            String apps = dataFromDeviceMapping.getAppsJSONFormated();



            if(!dataFromDB.apps.equals(apps)){
                //Log.e(TAG,"APSS MUST BE UPDATED" );
                dataToUpdate.put(TailDMPDb.DB_FIELD_APPS     ,apps);
            }

            if(!dataFromDB.brand.equals(dataFromDeviceMapping.getBrand())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_BRAND     ,dataFromDeviceMapping.getBrand());
            }
            if(!dataFromDB.product.equals(dataFromDeviceMapping.getProduct())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_PRODUCT     ,dataFromDeviceMapping.getProduct());
            }
            if(!dataFromDB.device.equals(dataFromDeviceMapping.getDevice())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_DEVICE     ,dataFromDeviceMapping.getDevice());
            }
            if(!dataFromDB.hardware.equals(dataFromDeviceMapping.getHardware())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_HARDWARE     ,dataFromDeviceMapping.getHardware());
            }
            if(!dataFromDB.manufacture.equals(dataFromDeviceMapping.getManufacturer())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_MANUFACTURER     ,dataFromDeviceMapping.getManufacturer());
            }
            if(!dataFromDB.model.equals(dataFromDeviceMapping.getModel())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_MODEL     ,dataFromDeviceMapping.getModel());
            }

            if(!dataFromDB.carrierName.equals(dataFromDeviceMapping.getCarrierName())){
                dataToUpdate.put(TailDMPDb.DB_FIELD_CARRIER_NAME     ,dataFromDeviceMapping.getCarrierName());
            }

            //Always send this data, its the current app that will run the SDK
            dataToUpdate.put(TailDMPDb.DB_FIELD_CURRENTAPP       ,dataFromDeviceMapping.getCurrentApp());

            String lastrequest = new Date().getTime()+"";
            dataToUpdate.put(TailDMPDb.DB_FIELD_LAST_REQUEST     ,lastrequest);

            dataToUpdate.put(TailDMPDb.DB_FIELD_ACCOUNTID     ,dataFromDeviceMapping.getAccountID());

            //Sometimes the activity tracker is not available when we are sending data to server, so we get the last activity saved on DB a send it to server
            if(dataFromDeviceMapping.getActivity().isEmpty()){
                dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY     ,dataFromDB.activity);
            }else{
                dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY     ,dataFromDeviceMapping.getActivity());
            }


        }else{
            //return desired device mapping data
            dataToUpdate.put(TailDMPDb.DB_FIELD_APIVERSION      ,dataFromDeviceMapping.getApiVersion());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF        ,dataFromDeviceMapping.getUserHashCPF());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL        ,dataFromDeviceMapping.getUserHashEmail());
            dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL        ,dataFromDeviceMapping.getUserHashTel());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID   ,dataFromDeviceMapping.getAdvertisingId());
            dataToUpdate.put(TailDMPDb.DB_FIELD_TAGS            ,dataFromDeviceMapping.getTagsJSONFormated().trim());
            dataToUpdate.put(TailDMPDb.DB_FIELD_LATITUDE        ,dataFromDeviceMapping.getLatitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLATITUDE        ,dataFromDeviceMapping.getLastLatitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LONGITUDE       ,dataFromDeviceMapping.getLongitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LASTLONGITUDE       ,dataFromDeviceMapping.getLastLongitude()+"");
            dataToUpdate.put(TailDMPDb.DB_FIELD_LANGUAGE        ,dataFromDeviceMapping.getLanguage());
            dataToUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE        ,dataFromDeviceMapping.getTimezone());
            dataToUpdate.put(TailDMPDb.DB_FIELD_OS              ,dataFromDeviceMapping.getOs());
            dataToUpdate.put(TailDMPDb.DB_FIELD_APPS            ,dataFromDeviceMapping.getAppsJSONFormated());
            dataToUpdate.put(TailDMPDb.DB_FIELD_BRAND           ,dataFromDeviceMapping.getBrand());
            dataToUpdate.put(TailDMPDb.DB_FIELD_PRODUCT         ,dataFromDeviceMapping.getProduct());
            dataToUpdate.put(TailDMPDb.DB_FIELD_DEVICE          ,dataFromDeviceMapping.getDevice());
            dataToUpdate.put(TailDMPDb.DB_FIELD_HARDWARE        ,dataFromDeviceMapping.getHardware());
            dataToUpdate.put(TailDMPDb.DB_FIELD_MANUFACTURER    ,dataFromDeviceMapping.getManufacturer());
            dataToUpdate.put(TailDMPDb.DB_FIELD_MODEL           ,dataFromDeviceMapping.getModel());
            dataToUpdate.put(TailDMPDb.DB_FIELD_CARRIER_NAME    ,dataFromDeviceMapping.getCarrierName());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACCOUNTID       ,dataFromDeviceMapping.getAccountID());
            //Always send this data, its the current app that will run the SDK
            dataToUpdate.put(TailDMPDb.DB_FIELD_CURRENTAPP       ,dataFromDeviceMapping.getCurrentApp());
            dataToUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY      ,dataFromDeviceMapping.getActivity());

            String lastrequest = new Date().getTime()+"";
            dataToUpdate.put(TailDMPDb.DB_FIELD_LAST_REQUEST     ,lastrequest);


        }
        /**************************
         * Generating hash to USER
        *************************/
        //get all 3 types of hash
        String hashEmail = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_EMAIL);
        String hashCPF = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_CPF);
        String hashTel = dataToUpdate.get(TailDMPDb.DB_FIELD_USERHASH_TEL);

        //call method to concat hashes
        String hash2Send = generateCompositeUserHash(hashEmail, hashCPF, hashTel);

        //if we generate a new userHash we must set it to devicemap
        dataFromDeviceMapping.setUserHash(hash2Send);

        //add created userhash to map
        dataToUpdate.put(TailDMPDb.DB_FIELD_USERHASH    ,hash2Send);

        return dataToUpdate;

    }

    //get database
    private SQLiteDatabase db = null;

    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }


    @Override
    protected String doInBackground(Object... params) {

        Log.i(TailDMPValues.TAG,"==| Trying to collect data");
        str = "";

        //TailDMP_Crypto crypto = new TailDMP_Crypto(context);

        int count = params.length;

        //get the database singleton
        TailDMPDb dbHelper = null;

        //get the user data from our database to be compared to current data collected
        TailDMPData dataFromDB = null;



        Cursor cursor = null;

        boolean isoptin = false;

        try{

            dbHelper = TailDMPDb.getInstance(context);

            db = dbHelper.getdatabase();

            dataFromDB = new TailDMPData();

            String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";

            cursor = db.rawQuery(query,null);

            if (cursor.moveToFirst()) {
                do {
                    dataFromDB.apiVersion = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APIVERSION));
                    dataFromDB.userHashCPF = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF));
                    dataFromDB.userHashEmail = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL));
                    dataFromDB.userHashTel = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL));
                    dataFromDB.advertisingId = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID));
                    dataFromDB.tags = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TAGS));
                    dataFromDB.latitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE));
                    dataFromDB.longitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LONGITUDE));
                    dataFromDB.language = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LANGUAGE));
                    dataFromDB.timezone = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TIMEZONE));
                    dataFromDB.os = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OS));
                    dataFromDB.device = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_DEVICE));
                    dataFromDB.manufacture = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MANUFACTURER));
                    dataFromDB.model = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_MODEL));
                    dataFromDB.hardware = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_HARDWARE));
                    dataFromDB.brand = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_BRAND));
                    dataFromDB.product = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_PRODUCT));
                    dataFromDB.apps = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS));
                    //Log.e(TAG,"FIND THIS APS ON DB"+cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS)).length());
                    dataFromDB.carrierName = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CARRIER_NAME));
                    dataFromDB.lastrequest = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));
                    dataFromDB.accountID = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID));
                    dataFromDB.activity = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACTIVITY));
                    dataFromDB.lastLatitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLATITUDE));
                    dataFromDB.lastLongitude = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLONGITUDE));
                    dataFromDB.updateCollectJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME));
                    dataFromDB.updateSendJobTime = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME));

                    String opt = cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_OPTIN));

                    if(opt.equals("1")){
                        isoptin = true;
                    }else{
                        isoptin = false;
                    }



                } while(cursor.moveToNext());
            }

        }catch(Exception e){
            Log.e(TailDMPValues.TAG, "Error while trying to get data from database "+e.getMessage());
        }finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }

            //db.close();
        }

        //compares the data of user 9999 with data of device map
        Map dt2send = checkdataTosend(dataFromDB, deviceMap);

        //Json to be sent
        String jsonToSend ="";

        //we only collect data if user is optin
        if(isoptin){


        if(dt2send.size() >0){

            //save data to send later
            //save the different data and updates user 9999 with the difference
            //dbHelper.saveDataForLater(dt2send);

            /******************
             * SAVE DATA ON DB
             *
             * We have 2 users on DB
             * User 9999 - main user that have complete info about device
             * User 91553 - user that has data collected now, but is different from data of user 9999
             *
             * Everytime we collect data we save the differences between user 9999 and the data collected now on a new register with user_id 91553.
             * We get these differences, update the user 9999 with it and keep his data in sync with last info collected.
             *
             *
            ******************/

            //values to be saved to user 91553
            ContentValues values2save = new ContentValues();

            //values to be saved to user 9999
            ContentValues values2update = new ContentValues();

            //copy all fields of db
            ArrayList<String> dbfields = new ArrayList<String>(TailDMPDb.dbfields);

            //remove these fields, we are not handling then
            dbfields.remove(TailDMPDb.DB_FIELD_UPDATE_COLLECT_JOB_TIME);
            dbfields.remove(TailDMPDb.DB_FIELD_UPDATE_SEND_JOB_TIME);

            //loop through db keys

            for (int i =0; i<dbfields.size(); i++) {

                //if we don' have this key add it to data to be saved on db with an empty value
                if(!dt2send.containsKey(dbfields.get(i))){

                    //add the value of USER_ID_SEND_DATA to user_id field
                    if(i == 0){
                        values2save.put(dbfields.get(i),TailDMPDb.USER_ID_SEND_DATA);
                    }else{
                        values2save.put(dbfields.get(i),"");
                    }
                }else{
                    //there is a key and a value on dt2save, save it to our values var
                    String val = "";

                    if (dt2send.get(dbfields.get(i)) == null){
                        val = "";
                    }else{
                        val = dt2send.get(dbfields.get(i)).toString();
                    }

                    values2save.put(dbfields.get(i),val);
                    values2update.put(dbfields.get(i),val);

                    //if(dbfields.get(i).equals(TailDMPDb.DB_FIELD_APPS)){
                        //Log.i(TAG,"????? APPS TO SAVE SIZE: " + val.length());
                    //}


                }

            }

            //query DB and count how may rows we have for user 91553
            String qryCount = "SELECT COUNT(*) FROM "+TailDMPDb.DATABASE_TABLE_NAME+" WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA;
            int countRegs = 0;

            //Oldest timestamp
            String oldestTimeStp = "";
            Cursor cursorCount = null;

            //rowid of data inserted
            long result = -1;


            try {

                cursorCount = db.rawQuery(qryCount,null);
                cursorCount.moveToFirst();

                countRegs = cursorCount.getInt(0);
                cursorCount.close();

                db.beginTransaction();

                //if the count is less than MAX we insert data to DB
                if (countRegs <= MAX_COLLECTED_DATAITENS) {

                    //insert data to user 91553
                    result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, values2save);


                    //update data in user 9999
                    int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values2update, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);
                    db.setTransactionSuccessful();
                    db.endTransaction();

                } else {
                    //if count is bigger than MAX remove the oldest and insert a new row


                    //select the oldest row ordered by the time it was collected
                    String qrySelectOldest = "SELECT * FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID_SEND_DATA + " ORDER BY " + TailDMPDb.DB_FIELD_LAST_REQUEST + " ASC LIMIT 1";
                    Cursor cursorSelectOldest = db.rawQuery(qrySelectOldest, null);

                    //Oldest timestamp
                    while (cursorSelectOldest.moveToNext()) {
                        //get the timestamp of oldest data entry
                        oldestTimeStp = cursorSelectOldest.getString(cursorSelectOldest.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));

                    }
                    //close cursor
                    cursorSelectOldest.close();

                    //==> Exclude the oldest data
                    String qryExcludeOldest = "DELETE FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID_SEND_DATA + " AND " + TailDMPDb.DB_FIELD_LAST_REQUEST + " =   " + oldestTimeStp;
                    db.execSQL(qryExcludeOldest);

                    //insert the new data

                    //==> insert data on user 91553
                    result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, values2save);

                    //==> update data in user 9999
                    int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values2update, TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID, null);

                    db.setTransactionSuccessful();
                    db.endTransaction();


                }

            }catch (Exception e) {
                Log.e(TailDMPValues.TAG, "TAsyncCollectData - Error while trying to add values to database"+e.getMessage());
            } finally {
                //db.endTransaction();

                //db.close();
            }


            str = dataFromDB.tags;

            long a = Integer.parseInt(dataFromDB.updateCollectJobTime);
            long b = new Date().getTime();

            Date date = new Date((a+b));
            DateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
            String nextrequest = formatter.format(date);

            //Log.i(TailDMPValues.TAG,"==| End of operation - Waiting until next request call ...");
            Log.i(TailDMPValues.TAG, "End of operation, if scheduled, we expect to run next Collect data job at: " + nextrequest );

        }

        }else{

            Log.e(TailDMP.TAG, "To Collect data the User must be optin.");
        }
        //return tags to be saved on device mapping by
        //onPostExecute() on TailDMPCollectDataJobService.java
        return str;

    }

    @Override
    protected void onPostExecute(String resultFromAsync) {
        super.onPostExecute(resultFromAsync);
        //do something with the result of doInBackground
        //Log.i(TAG,"TAsyncSendData - onPostExecute() result : "+ resultFromAsync);

    }
}
