package digital.tail.sdk.tail_mobile_sdk;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;

import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;

import java.io.IOException;

import static com.google.android.gms.ads.identifier.AdvertisingIdClient.getAdvertisingIdInfo;

public class TAsyncAdvID extends AsyncTask<Void, Void, String> {

    public TAsyncAdvID(Context context){
        this.context = context;
    }

    private Context context;

    @Override
    protected String doInBackground(Void... voids) {
        String id;

        try {

            if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) != ConnectionResult.SUCCESS) {
                Log.e(TailDMPValues.TAG,"GoogleApiAvailability NOT available " + GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context));
                id = "not-available";
            }

            AdvertisingIdClient.Info advInfo = getAdvertisingIdInfo(context);

            //advInfo = null;

            if (advInfo ==null ){
                //can't get advID
                id = "not-available";
            }else if( advInfo.isLimitAdTrackingEnabled()) {
                //user opts out
                id = "opt-out";
            } else {

                //id available
                id = advInfo.getId();
            }

        } catch (Exception e) {
            e.printStackTrace();
            id = "not-available";
        }

        return id;
    }


}
