package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import java.util.ArrayList;
import java.util.Date;

/**
 * Created by diego_saito on 5/17/17.
 */

 class TAsyncAddOrUpdateTag extends AsyncTask <String, Void, String>{

    public SQLiteDatabase db;

    public TAsyncAddOrUpdateTag(SQLiteDatabase db){
        this.db = db;
    }

    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    @Override
    protected String doInBackground(String... params) {
        String data = params[0];

        try {
            db.beginTransaction();

            //values to be sent
            ContentValues valuesInsert = new ContentValues();
            ContentValues valuesUpdate = new ContentValues();

            //query database to check if there is an user
            String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";
            Cursor cursor = db.rawQuery(query,null);
            int count = cursor.getCount();

            String lastrequest = new Date().getTime()+"";

            if (cursor.moveToFirst()) {
                do {
                    //id of user 91553
                    valuesInsert.put(TailDMPDb.DB_FIELD_USER_ID, TailDMPDb.USER_ID_SEND_DATA) ;
                    valuesInsert.put(TailDMPDb.DB_FIELD_USERHASH, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_USERHASH_CPF,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_CPF)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_USERHASH_TEL, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_TEL)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL , cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_USERHASH_EMAIL)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_ADVERTISINGID , cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ADVERTISINGID)) );
                    //add the new tag
                    valuesInsert.put(TailDMPDb.DB_FIELD_TAGS ,data );
                    valuesInsert.put(TailDMPDb.DB_FIELD_LATITUDE,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LATITUDE)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_LONGITUDE,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LONGITUDE)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_LASTLATITUDE,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLATITUDE)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_LASTLONGITUDE)) );

                    valuesInsert.put(TailDMPDb.DB_FIELD_TIMEZONE,  cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_TIMEZONE)) );
                    //valuesInsert.put(TailDMPDb.DB_FIELD_APPS, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_APPS)) );
                    //valuesInsert.put(TailDMPDb.DB_FIELD_CARRIER_NAME, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CARRIER_NAME)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_LAST_REQUEST, lastrequest );
                    valuesInsert.put(TailDMPDb.DB_FIELD_ACCOUNTID, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACCOUNTID)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_CURRENTAPP , cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_CURRENTAPP)) );
                    valuesInsert.put(TailDMPDb.DB_FIELD_ACTIVITY, cursor.getString(cursor.getColumnIndex(TailDMPDb.DB_FIELD_ACTIVITY)) );

                } while(cursor.moveToNext());
            }



            if(count>0){
                //if we have one user 9999, update TAG
                valuesUpdate.put(TailDMPDb.DB_FIELD_TAGS,data);

                //UPDATES USER 9999
                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, valuesUpdate, TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID, null);
                if(rows == 1){
                    Log.i(TailDMPValues.TAG,"TAsyncAddOrUpdateTag DB UPDATED");
                }else{
                    Log.i(TailDMPValues.TAG,"TAsyncAddOrUpdateTag DB NOT UPDATED ");
                }



                //INSERT CHANGES USER 91553

                //query DB and count how may rows we have for user 91553
                String qryCount = "SELECT COUNT(*) FROM "+TailDMPDb.DATABASE_TABLE_NAME+" WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID_SEND_DATA;
                Cursor cursorCount = db.rawQuery(qryCount,null);
                cursorCount.moveToFirst();
                int countRegs = cursorCount.getInt(0);
                cursorCount.close();

                //Oldest timestamp of a row to be removed if we have more than MAX_COLLECTED_DATAITENS
                String oldestTimeStp = "";

                //if the count is less than MAX we insert data to DB
                if (countRegs <= TAsyncCollectData.MAX_COLLECTED_DATAITENS) {

                    //rowid of data inserted
                    long result = -1;
                    //insert data to user 91553
                    result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, valuesInsert);



                } else {
                    //if count is bigger than MAX remove the oldest and insert a new row


                    //select the oldest row ordered by the time it was collected
                    String qrySelectOldest = "SELECT * FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID_SEND_DATA + " ORDER BY " + TailDMPDb.DB_FIELD_LAST_REQUEST + " ASC LIMIT 1";
                    Cursor cursorSelectOldest = db.rawQuery(qrySelectOldest, null);

                    //Oldest timestamp
                    while (cursorSelectOldest.moveToNext()) {
                        //get the timestamp of oldest data entry
                        oldestTimeStp = cursorSelectOldest.getString(cursorSelectOldest.getColumnIndex(TailDMPDb.DB_FIELD_LAST_REQUEST));

                    }
                    //close cursor
                    cursorSelectOldest.close();

                    //==> Exclude the oldest data
                    String qryExcludeOldest = "DELETE FROM " + TailDMPDb.DATABASE_TABLE_NAME + " WHERE " + TailDMPDb.DB_FIELD_USER_ID + " = " + TailDMPDb.USER_ID_SEND_DATA + " AND " + TailDMPDb.DB_FIELD_LAST_REQUEST + " = " + oldestTimeStp;
                    db.execSQL(qryExcludeOldest);

                    //insert the new data

                    //rowid of data inserted
                    long result = -1;

                    //==> insert data on user 91553
                    result = db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, valuesInsert);


                }


            }else{
                //if we don't have an user, insert data
                valuesUpdate.put(TailDMPDb.DB_FIELD_USER_ID,TailDMPDb.USER_ID);
                valuesUpdate.put(TailDMPDb.DB_FIELD_APIVERSION,android.os.Build.VERSION.SDK_INT+"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_USERHASH_TEL,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_USERHASH,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_USERHASH_CPF,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_ADVERTISINGID,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_TAGS,data);
                valuesUpdate.put(TailDMPDb.DB_FIELD_LATITUDE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_LONGITUDE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_LASTLATITUDE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_LANGUAGE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_TIMEZONE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_OS,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_APPS,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_BRAND,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_PRODUCT,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_DEVICE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_HARDWARE,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_MANUFACTURER,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_CARRIER_NAME,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_MODEL,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_ACCOUNTID,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_ACTIVITY,"");
                valuesUpdate.put(TailDMPDb.DB_FIELD_LAST_REQUEST, lastrequest);

                db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, valuesUpdate);

            }


        } catch (Exception e) {
            Log.e(TailDMPValues.TAG, "Error while trying to add values to database"+e.getMessage());
        } finally {
            if(hasDB() && db.isOpen()) {
                db.setTransactionSuccessful();
                db.endTransaction();
            }
        }

        return null;
    }
}
