package digital.tail.sdk.tail_mobile_sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.AsyncTask;
import android.util.Log;

import java.util.Date;

/**
 * Created by diego_saito on 5/10/17.
 */

 class TAsyncAddData extends AsyncTask<TailDMPDeviceMapping, Void, String> {

    protected static final String TAG = TailDMPValues.TAG;

    public SQLiteDatabase db;

    private boolean hasDB(){
        boolean hasit = false;
        if(db != null){
            hasit = true;
        }
        return hasit;
    }

    public TAsyncAddData(SQLiteDatabase db){
        this.db = db;
    }

    @Override
    protected String doInBackground(TailDMPDeviceMapping... params) {

        TailDMPDeviceMapping data = params[0];
        try {
            db.beginTransaction();

            //values to be sent
            ContentValues values = new ContentValues();

            String lastrequest = new Date().getTime()+"";
            values.put(TailDMPDb.DB_FIELD_LAST_REQUEST,lastrequest);

            //query database to check if there is an user
            String query = "SELECT * FROM "+TailDMPDb.DATABASE_TABLE_NAME+ " WHERE "+TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID+";";
            Cursor cursor = db.rawQuery(query,null);
            int count = cursor.getCount();

            if(count>0){
                //if we have one user, update data

                values.put(TailDMPDb.DB_FIELD_USERHASH_TEL,data.getUserHashTel());
                values.put(TailDMPDb.DB_FIELD_USERHASH,data.getUserHash());
                values.put(TailDMPDb.DB_FIELD_USERHASH_CPF,data.getUserHashCPF());
                values.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL,data.getUserHashEmail());
                values.put(TailDMPDb.DB_FIELD_ADVERTISINGID,data.getAdvertisingId());
                values.put(TailDMPDb.DB_FIELD_TAGS,data.getTagsJSONFormated());
                values.put(TailDMPDb.DB_FIELD_LATITUDE,data.getLatitude());
                values.put(TailDMPDb.DB_FIELD_LONGITUDE,data.getLongitude());
                values.put(TailDMPDb.DB_FIELD_LASTLATITUDE,data.getLastLatitude());
                values.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,data.getLastLongitude());
                values.put(TailDMPDb.DB_FIELD_OS,data.getOs());
                values.put(TailDMPDb.DB_FIELD_APPS,data.getAppsJSONFormated());
                values.put(TailDMPDb.DB_FIELD_CARRIER_NAME,data.getCarrierName());
                values.put(TailDMPDb.DB_FIELD_ACCOUNTID,data.getAccountID());
                values.put(TailDMPDb.DB_FIELD_ACTIVITY,data.getActivity());


                int rows = db.update(TailDMPDb.DATABASE_TABLE_NAME, values, TailDMPDb.DB_FIELD_USER_ID+" = "+TailDMPDb.USER_ID, null);
                if(rows == 1){
                    Log.i(TailDMPValues.TAG,"TAsyncAddData DB UPDATED");
                }else{
                    Log.i(TailDMPValues.TAG,"TAsyncAddData DB NOT UPDATED");
                }
                db.setTransactionSuccessful();

            }else{
                //if we don't have an user, insert data
                values.put(TailDMPDb.DB_FIELD_USER_ID,TailDMPDb.USER_ID);
                values.put(TailDMPDb.DB_FIELD_APIVERSION,"");
                values.put(TailDMPDb.DB_FIELD_USERHASH,"");
                values.put(TailDMPDb.DB_FIELD_USERHASH_CPF,"");
                values.put(TailDMPDb.DB_FIELD_USERHASH_EMAIL,"");
                values.put(TailDMPDb.DB_FIELD_USERHASH_TEL,"");
                values.put(TailDMPDb.DB_FIELD_ADVERTISINGID,"");
                values.put(TailDMPDb.DB_FIELD_TAGS,"");
                values.put(TailDMPDb.DB_FIELD_LATITUDE,"");
                values.put(TailDMPDb.DB_FIELD_LONGITUDE,"");
                values.put(TailDMPDb.DB_FIELD_LANGUAGE,"");
                values.put(TailDMPDb.DB_FIELD_LASTLATITUDE,"");
                values.put(TailDMPDb.DB_FIELD_LASTLONGITUDE,"");
                values.put(TailDMPDb.DB_FIELD_TIMEZONE,"");
                values.put(TailDMPDb.DB_FIELD_OS,"");
                values.put(TailDMPDb.DB_FIELD_APPS,"");
                values.put(TailDMPDb.DB_FIELD_BRAND,"");
                values.put(TailDMPDb.DB_FIELD_PRODUCT,"");
                values.put(TailDMPDb.DB_FIELD_DEVICE,"");
                values.put(TailDMPDb.DB_FIELD_HARDWARE,"");
                values.put(TailDMPDb.DB_FIELD_MANUFACTURER,"");
                values.put(TailDMPDb.DB_FIELD_CARRIER_NAME,"");
                values.put(TailDMPDb.DB_FIELD_MODEL,"");
                values.put(TailDMPDb.DB_FIELD_ACCOUNTID,"");
                values.put(TailDMPDb.DB_FIELD_ACTIVITY,"");


                db.insertOrThrow(TailDMPDb.DATABASE_TABLE_NAME, null, values);
                db.setTransactionSuccessful();
            }


        } catch (Exception e) {
            Log.e(TailDMPValues.TAG, "Error while trying to add values to database"+e.getMessage());
        } finally {
            if(hasDB() && db.isOpen()) {
                db.endTransaction();
            }
        }

        return null;
    }

    @Override
    protected void onPostExecute(String s) {
        super.onPostExecute(s);
    }
}
