/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.transport;

import digital.nedra.commons.starter.witsml.clt.config.WitsmlServerProperties;
import digital.nedra.commons.starter.witsml.clt.exception.WitsmlAuthorizationTokenException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class TokenProvider {
    private final WitsmlServerProperties witsmlServerProperties;
    private final RestTemplate restTemplate = new RestTemplate();

    public String getAuthorizationToken() {
        try {
            MultiValueMap<String, String> body = this.getBody();
            HttpHeaders headers = this.getHeaders();
            HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
            String authUrl = this.witsmlServerProperties.getUrl() + "/auth";
            return (String)this.restTemplate.postForEntity(authUrl, (Object)httpEntity, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new WitsmlAuthorizationTokenException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0442\u043e\u043a\u0435\u043d\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438.: " + e.getMessage());
        }
    }

    private MultiValueMap<String, String> getBody() {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"username", (Object)this.witsmlServerProperties.getUsername());
        formData.add((Object)"password", (Object)this.witsmlServerProperties.getPassword());
        formData.add((Object)"grant_type", (Object)"password");
        return formData;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    public TokenProvider(WitsmlServerProperties witsmlServerProperties) {
        this.witsmlServerProperties = witsmlServerProperties;
    }
}

