/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.transport;

import digital.nedra.commons.starter.witsml.clt.config.WitsmlServerProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

@Component
@ConditionalOnProperty(prefix="starters.witsml-clt.witsml-server", name={"authentication-type"}, havingValue="basic")
public class BasicAuthMessageSender
extends HttpUrlConnectionMessageSender {
    private final String authorizationHeader;

    public BasicAuthMessageSender(WitsmlServerProperties witsmlServerProperties) {
        this.authorizationHeader = "Basic " + this.encodedCredentials(witsmlServerProperties.getUsername(), witsmlServerProperties.getPassword());
    }

    private String encodedCredentials(String username, String password) {
        byte[] credentialsBytes = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(credentialsBytes);
    }

    protected void prepareConnection(HttpURLConnection connection) throws IOException {
        super.prepareConnection(connection);
        connection.setRequestProperty("Authorization", this.authorizationHeader);
    }
}

