/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.controller;

import digital.nedra.commons.starter.witsml.clt.model.soap.WmlsGetFromStore;
import digital.nedra.commons.starter.witsml.clt.service.WitsmlGatewayService;
import jakarta.validation.constraints.NotBlank;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"${starters.witsml-clt.witsml-server.path}"})
@ConditionalOnProperty(prefix="starters.witsml-clt.witsml-server", name={"path"})
public class WitsmlSoapController {
    private final WitsmlGatewayService witsmlGatewayService;

    @PostMapping
    public ResponseEntity<String> postWitsmlRequestForStore(@NotBlank @RequestBody String requestWitsmlString) {
        WmlsGetFromStore fromStore = this.witsmlGatewayService.prepareGetObject(requestWitsmlString);
        Optional<String> fromStoreRawString = this.witsmlGatewayService.getFromStoreRawString(fromStore);
        return fromStoreRawString.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    public WitsmlSoapController(WitsmlGatewayService witsmlGatewayService) {
        this.witsmlGatewayService = witsmlGatewayService;
    }
}

