/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt;

import digital.nedra.commons.starter.witsml.clt.config.WitsmlServerProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

@Configuration
@ComponentScan
@AutoConfigureOrder(value=-2147483648)
@EnableConfigurationProperties(value={WitsmlServerProperties.class})
public class WitsmlClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WitsmlClientConfiguration.class);

    @PostConstruct
    public void init() {
        log.info("Starter: witsml-clt-starter started");
    }

    @Bean
    public Jaxb2Marshaller witsmlJaxb2Marshaller() {
        Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
        jaxb2Marshaller.setContextPath("digital.nedra.commons.starter.witsml.clt.model.soap");
        return jaxb2Marshaller;
    }

    @Bean
    @ConditionalOnProperty(prefix="starters.witsml-clt.witsml-server", name={"authentication-type"}, havingValue="no-auth")
    public WebServiceMessageSender httpUrlConnectionMessageSender() {
        return new HttpUrlConnectionMessageSender();
    }
}

