/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.witsml.clt.validator;

import digital.nedra.commons.starter.witsml.clt.constant.ExceptionMessages;
import digital.nedra.commons.starter.witsml.clt.exception.WitsmlValidationException;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.stereotype.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class SaxParserValidatorImpl implements SaxParserValidator {
  @Override
  public void validate(String witsmlString) {
    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
      SAXParser parser = factory.newSAXParser();
      parser.getXMLReader().parse(new InputSource(new StringReader(witsmlString)));
    } catch (IOException | SAXException | ParserConfigurationException e) {
      throw new WitsmlValidationException(ExceptionMessages.INVALID_WITSML_FORMAT);
    }
  }
}
