/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.witsml.clt.transport;

import static digital.nedra.commons.starter.witsml.clt.constant.ConstantMessages.BASIC_PLACEHOLDER;

import digital.nedra.commons.starter.witsml.clt.config.WitsmlServerProperties;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.ws.transport.http.HttpUrlConnectionMessageSender;

@Component
@ConditionalOnProperty(
    prefix = "starters.witsml-clt.witsml-server",
    name = "authentication-type",
    havingValue = "basic")
public class BasicAuthMessageSender extends HttpUrlConnectionMessageSender {

  private final String authorizationHeader;

  public BasicAuthMessageSender(WitsmlServerProperties witsmlServerProperties) {
    authorizationHeader = BASIC_PLACEHOLDER
        + encodedCredentials(witsmlServerProperties.getUsername(),
        witsmlServerProperties.getPassword());
  }

  private String encodedCredentials(String username, String password) {
    byte[] credentialsBytes = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
    return Base64.getEncoder().encodeToString(credentialsBytes);
  }

  @Override
  protected void prepareConnection(HttpURLConnection connection) throws IOException {
    super.prepareConnection(connection);
    connection.setRequestProperty(HttpHeaders.AUTHORIZATION, authorizationHeader);
  }
}