/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.witsml.clt.exception.handler;

import digital.nedra.commons.starter.witsml.clt.exception.WitsmlAuthorizationTokenException;
import digital.nedra.commons.starter.witsml.clt.exception.WitsmlClientException;
import digital.nedra.commons.starter.witsml.clt.exception.WitsmlValidationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class StarterExceptionHandler extends ResponseEntityExceptionHandler {

  @ExceptionHandler(WitsmlValidationException.class)
  protected ResponseEntity<String> handleWitsmlValidationException(Exception exception) {
    return new ResponseEntity<>(exception.getMessage(), HttpStatus.BAD_REQUEST);
  }

  @ExceptionHandler(WitsmlAuthorizationTokenException.class)
  protected ResponseEntity<String> handleWitsmlAuthorizationTokenException(Exception exception) {
    return new ResponseEntity<>(exception.getMessage(), HttpStatus.FORBIDDEN);
  }

  @ExceptionHandler(WitsmlClientException.class)
  protected ResponseEntity<String> handleWitsmlClientException(Exception exception) {
    return new ResponseEntity<>(exception.getMessage(), HttpStatus.NOT_FOUND);
  }
}
