/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.witsml.clt.controller;

import digital.nedra.commons.starter.witsml.clt.model.soap.WmlsGetFromStore;
import digital.nedra.commons.starter.witsml.clt.service.WitsmlGatewayService;
import jakarta.validation.constraints.NotBlank;
import java.util.Optional;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping("${starters.witsml-clt.witsml-server.path}")
@ConditionalOnProperty(prefix = "starters.witsml-clt.witsml-server", name = "path")
@RequiredArgsConstructor
public class WitsmlSoapController {

  private final WitsmlGatewayService witsmlGatewayService;

  /**
   * Контроллер для получения запросов и делегирования вызова в SoapClient.
   * @param requestWitsmlString WITSML строка для обращения к серверу.
   * @return WITSML строка с ответом по указанному типу, в случае нахождения.
   */
  @PostMapping
  public ResponseEntity<String> postWitsmlRequestForStore(
      @NotBlank @RequestBody String requestWitsmlString) {
    WmlsGetFromStore fromStore = witsmlGatewayService.prepareGetObject(requestWitsmlString);
    Optional<String> fromStoreRawString = witsmlGatewayService.getFromStoreRawString(fromStore);
    return fromStoreRawString.map(ResponseEntity::ok)
        .orElseGet(() -> ResponseEntity.notFound().build());
  }
}
