/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.witsml.clt.config;

import digital.nedra.commons.starter.witsml.clt.model.WitsmlVersion;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

/**
 * Сгруппированные параметры подключения к WITSML серверу. Источником данных являются параметры
 * из application.yml c префиксом starters.witsml-clt.witsml-server.
 */
@Getter
@Setter
@Validated
@ConfigurationProperties(prefix = "starters.witsml-clt.witsml-server")
public class WitsmlServerProperties {
  /**
   * Адрес WITSML сервера.
   */
  @NotNull
  private URI url;

  /**
   * Имя пользователя для подключения к WITSML серверу.
   */
  private String username;

  /**
   * Пароль для подключения к WITSML серверу.
   */
  private String password;

  /**
   * Версия WITSML.
   */
  @NotNull
  private WitsmlVersion version;

  /**
   * Тип аутентификации.
   */
  @NotBlank
  private String authenticationType;

  /**
   * Путь для создания контроллера с POST запросом.
   */
  private String path;
}
