/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.service;

import digital.nedra.commons.starter.witsml.clt.config.WitsmlServerProperties;
import digital.nedra.commons.starter.witsml.clt.exception.WitsmlClientException;
import digital.nedra.commons.starter.witsml.clt.model.soap.WmlsGetFromStore;
import digital.nedra.commons.starter.witsml.clt.model.soap.WmlsGetFromStoreResponse;
import digital.nedra.commons.starter.witsml.clt.validator.SaxParserValidator;
import java.util.Optional;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.stereotype.Service;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.springframework.ws.soap.client.core.SoapActionCallback;
import org.springframework.ws.transport.WebServiceMessageSender;

@Service
public class WitsmlGatewayService
extends WebServiceGatewaySupport {
    protected final WitsmlServerProperties witsmlServerProperties;
    private final SaxParserValidator saxParserValidator;
    private final SoapActionCallback soapActionCallback = new SoapActionCallback("http://www.witsml.org/action/120/Store.WMLS_GetFromStore");

    public WitsmlGatewayService(WitsmlServerProperties witsmlServerProperties, WebServiceMessageSender messageSender, Jaxb2Marshaller marshaller, SaxParserValidator validator) {
        this.witsmlServerProperties = witsmlServerProperties;
        this.saxParserValidator = validator;
        this.setMessageSender(messageSender);
        this.setMarshaller((Marshaller)marshaller);
        this.setUnmarshaller((Unmarshaller)marshaller);
    }

    public WmlsGetFromStore prepareGetObject(String requestWitsmlString) {
        this.saxParserValidator.validate(requestWitsmlString);
        String objName = requestWitsmlString.substring(1, requestWitsmlString.indexOf(" ") - 1);
        WmlsGetFromStore fromStore = new WmlsGetFromStore();
        fromStore.setWmlTypeIn(objName);
        fromStore.setQueryIn(requestWitsmlString);
        return fromStore;
    }

    public Optional<String> getFromStoreRawString(WmlsGetFromStore request) {
        try {
            WmlsGetFromStoreResponse response = this.marshalSendAndReceive(request);
            String xmlOut = response.getXmlOut();
            return Optional.ofNullable(xmlOut);
        }
        catch (Exception e) {
            throw new WitsmlClientException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 witsml-server: " + e.getMessage());
        }
    }

    private WmlsGetFromStoreResponse marshalSendAndReceive(WmlsGetFromStore request) {
        return (WmlsGetFromStoreResponse)this.getWebServiceTemplate().marshalSendAndReceive(this.witsmlServerProperties.getUrl().toString(), (Object)request, (WebServiceMessageCallback)this.soapActionCallback);
    }
}

