/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.validator;

import digital.nedra.commons.starter.witsml.clt.exception.WitsmlValidationException;
import digital.nedra.commons.starter.witsml.clt.validator.SaxParserValidator;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.stereotype.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class SaxParserValidatorImpl
implements SaxParserValidator {
    @Override
    public void validate(String witsmlString) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            SAXParser parser = factory.newSAXParser();
            parser.getXMLReader().parse(new InputSource(new StringReader(witsmlString)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new WitsmlValidationException("\u041f\u043e\u0434\u0430\u043d \u043d\u0435\u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 XML \u0444\u0430\u0439\u043b.");
        }
    }
}

