/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.witsml.clt.transport;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import digital.nedra.commons.starter.witsml.clt.transport.AbstractBearerAuthMessageSender;
import digital.nedra.commons.starter.witsml.clt.transport.TokenProvider;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="starters.witsml-clt.witsml-server", name={"authentication-type"}, havingValue="in-memory-bearer")
public class InMemoryBearerAuthMessageSender
extends AbstractBearerAuthMessageSender {
    private final ReentrantLock reentrantLock = new ReentrantLock();
    private final AtomicReference<DecodedJWT> jwtReference = new AtomicReference();
    private final TokenProvider tokenProvider;

    @Override
    public String getToken() {
        if (this.isTokenExpired()) {
            this.reentrantLock.lock();
            try {
                if (this.isTokenExpired()) {
                    DecodedJWT jwt = JWT.decode((String)this.tokenProvider.getAuthorizationToken());
                    this.jwtReference.set(jwt);
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        return this.jwtReference.get().getToken();
    }

    private boolean isTokenExpired() {
        DecodedJWT jwt = this.jwtReference.get();
        if (jwt == null) {
            return true;
        }
        Instant expirationDateTime = jwt.getExpiresAtAsInstant();
        return expirationDateTime == null || !Instant.now().isBefore(expirationDateTime);
    }

    public InMemoryBearerAuthMessageSender(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }
}

