/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package digital.nedra.commons.starter.witsml.clt.model.soap;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "result",
    "xmlOut",
    "supplementalMessage"
})
@XmlRootElement(name = "WMLS_GetFromStoreResponse")
public class WmlsGetFromStoreResponse {

  @XmlElement(name = "Result", required = true, type = Short.class, nillable = true)
  private Short result;

  @XmlElement(name = "XMLout", required = true, nillable = true)
  private String xmlOut;

  @XmlElement(name = "SuppMsgOut", required = true, nillable = true)
  private String supplementalMessage;
}