/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.swagger.config;

import digital.nedra.commons.starter.common.config.properties.OAuth2Properties;
import digital.nedra.commons.starter.common.config.properties.SwaggerProperties;
import digital.nedra.commons.starter.swagger.config.security.schema.CustomSecuritySchema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(name={"digital.nedra.commons.starter.security.oauth2.bearer.OAuth2StarterAutoConfiguration"})
public class SwaggerOAuth2BearerConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SwaggerOAuth2BearerConfigurer.class);
    private final OAuth2Properties oauth2Properties;
    private final SwaggerProperties swaggerProperties;
    private final Map<SwaggerProperties.SecuritySchemaFlow, CustomSecuritySchema> securitySchemasMap;
    private final OpenAPI openApiConfig;

    public SwaggerOAuth2BearerConfigurer(OAuth2Properties oauth2Properties, SwaggerProperties swaggerProperties, Set<CustomSecuritySchema> securitySchemeList) {
        this.oauth2Properties = oauth2Properties;
        this.swaggerProperties = swaggerProperties;
        this.securitySchemasMap = securitySchemeList.stream().collect(Collectors.toMap(CustomSecuritySchema::getFlow, Function.identity()));
        this.openApiConfig = this.buildOpenApiConfig();
    }

    @Bean
    public OpenAPI getOpenApiConfig() {
        return this.openApiConfig;
    }

    @Bean
    public GroupedOpenApi adminApi() {
        return GroupedOpenApi.builder().group("API").pathsToMatch(new String[]{this.swaggerProperties.getAllowedPaths()}).build();
    }

    @Bean
    @Primary
    public SwaggerUiOAuthProperties swaggerUiOAuthProperties(SwaggerUiOAuthProperties properties) {
        properties.setClientId(this.oauth2Properties.getClientId());
        properties.setClientSecret(this.oauth2Properties.getClientSecret());
        properties.setScopeSeparator(" ");
        return properties;
    }

    private OpenAPI buildOpenApiConfig() {
        List<SecurityScheme> securitySchemeList = this.getSelectedSchemes();
        OpenAPI openApi = new OpenAPI();
        if (!securitySchemeList.isEmpty()) {
            Components components = new Components();
            securitySchemeList.forEach(scheme -> components.addSecuritySchemes(scheme.getName(), scheme));
            List securityRequirements = securitySchemeList.stream().map(SecurityScheme::getName).map(schema -> new SecurityRequirement().addList(schema, schema)).collect(Collectors.toCollection(ArrayList::new));
            openApi.components(components).security(securityRequirements);
            securitySchemeList.forEach(scheme -> log.info("Security schema {} is added.", (Object)scheme.getName()));
        } else {
            log.warn("Oauth2 starter is enable, but swagger ui auth flow is empty.");
        }
        return openApi;
    }

    private List<SecurityScheme> getSelectedSchemes() {
        List selectedFlows = this.swaggerProperties.getSecurity().getFlows();
        return selectedFlows.stream().map(this.securitySchemasMap::get).map(CustomSecuritySchema::build).toList();
    }
}

