/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.swagger.config.security.schema;

import digital.nedra.commons.starter.common.config.properties.OAuth2Properties;
import digital.nedra.commons.starter.common.config.properties.SwaggerProperties;
import digital.nedra.commons.starter.security.dto.OidcConfigurationDto;
import digital.nedra.commons.starter.security.service.OidcConfigurationResolver;
import digital.nedra.commons.starter.swagger.config.security.schema.CustomSecuritySchema;
import digital.nedra.commons.starter.swagger.util.ScopeUtils;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AuthorizationCodeSchema
extends CustomSecuritySchema {
    private final OAuth2Properties oauth2Properties;
    private final OidcConfigurationResolver oidcConfigurationResolver;
    private static final String CONFIG_FAILED_MSG = "Unable to config authorization code flow security schema.";
    private String authorizationUrl;
    private String tokenUrl;

    protected AuthorizationCodeSchema(OAuth2Properties oauth2Properties, @Autowired(required=false) OidcConfigurationResolver oidcConfigurationResolver) {
        super(SwaggerProperties.SecuritySchemaFlow.AUTHORIZATION_CODE);
        this.oauth2Properties = oauth2Properties;
        this.oidcConfigurationResolver = oidcConfigurationResolver;
    }

    @Override
    public SecurityScheme build() {
        this.setUp();
        return new SecurityScheme().name("AUTHORIZATION CODE").type(SecurityScheme.Type.OAUTH2).description("Oauth2 authorization code flow").flows(new OAuthFlows().authorizationCode(new OAuthFlow().authorizationUrl(this.authorizationUrl).tokenUrl(this.tokenUrl).scopes(ScopeUtils.buildScopesFromConfig(this.oauth2Properties.getScopes()))));
    }

    private void setUp() {
        String authorizationUrlFromResource = this.oauth2Properties.getAuthorizationUrl();
        String tokenUrlFromResource = this.oauth2Properties.getTokenUrl();
        if (this.oidcConfigurationResolver != null) {
            this.authorizationUrl = this.oidcConfigurationResolver.getOidcConfiguration().map(OidcConfigurationDto::getAuthorizationEndpoint).orElse(authorizationUrlFromResource);
            this.tokenUrl = this.oidcConfigurationResolver.getOidcConfiguration().map(OidcConfigurationDto::getTokenEndpoint).orElse(tokenUrlFromResource);
        } else {
            this.authorizationUrl = authorizationUrlFromResource;
            this.tokenUrl = tokenUrlFromResource;
        }
        Assert.notNull((Object)this.authorizationUrl, (String)"Unable to config authorization code flow security schema.Authorization url is null.");
        Assert.notNull((Object)this.tokenUrl, (String)"Unable to config authorization code flow security schema.Token url is null.");
        Assert.notNull((Object)this.oauth2Properties.getClientId(), (String)"Unable to config authorization code flow security schema.ClientId is null.");
    }
}

