package digital.nedra.commons.starter.swagger.util;

import io.swagger.v3.oas.models.security.Scopes;
import java.util.List;
import lombok.experimental.UtilityClass;

@UtilityClass
public class ScopeUtils {
  public Scopes buildScopesFromConfig(List<String> scopeStrList) {
    if (scopeStrList == null) {
      return new Scopes();
    }
    final Scopes scopes = new Scopes();
    scopeStrList
        .forEach(prop -> scopes.addString(prop, prop));
    return scopes;
  }
}
