/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.swagger.config.security.schema;

import digital.nedra.commons.starter.common.config.properties.OAuth2Properties;
import digital.nedra.commons.starter.common.config.properties.SwaggerProperties;
import digital.nedra.commons.starter.security.dto.OidcConfigurationDto;
import digital.nedra.commons.starter.security.service.OidcConfigurationResolver;
import digital.nedra.commons.starter.swagger.config.security.schema.CustomSecuritySchema;
import digital.nedra.commons.starter.swagger.util.ScopeUtils;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ImplicitSchema
extends CustomSecuritySchema {
    private final OAuth2Properties oauth2Properties;
    private final OidcConfigurationResolver oidcConfigurationResolver;
    private static final String CONFIG_FAILED_MSG = "Unable to config implicit flow security schema. ";
    private String authorizationUrl;

    protected ImplicitSchema(OAuth2Properties oauth2Properties, @Autowired(required=false) OidcConfigurationResolver oidcConfigurationResolver) {
        super(SwaggerProperties.SecuritySchemaFlow.IMPLICIT);
        this.oauth2Properties = oauth2Properties;
        this.oidcConfigurationResolver = oidcConfigurationResolver;
    }

    @Override
    public SecurityScheme build() {
        this.setUp();
        return new SecurityScheme().name("IMPLICIT").type(SecurityScheme.Type.OAUTH2).description("Oauth2 implicit flow").in(SecurityScheme.In.HEADER).flows(new OAuthFlows().implicit(new OAuthFlow().authorizationUrl(this.authorizationUrl).scopes(ScopeUtils.buildScopesFromConfig(this.oauth2Properties.getScopes()))));
    }

    private void setUp() {
        String authorizationUrlFromResource = this.oauth2Properties.getAuthorizationUrl();
        this.authorizationUrl = this.oidcConfigurationResolver != null ? this.oidcConfigurationResolver.getOidcConfiguration().map(OidcConfigurationDto::getAuthorizationEndpoint).orElse(authorizationUrlFromResource) : authorizationUrlFromResource;
        Assert.notNull((Object)this.authorizationUrl, (String)"Unable to config implicit flow security schema. Authorization url is null.");
        Assert.notNull((Object)this.oauth2Properties.getClientId(), (String)"Unable to config implicit flow security schema. ClientId is null.");
    }
}

