/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.swagger.config.security.schema;

import digital.nedra.commons.starter.common.config.properties.SwaggerProperties;
import io.swagger.v3.oas.models.security.SecurityScheme;

public abstract class CustomSecuritySchema {
  private final SwaggerProperties.SecuritySchemaFlow flow;

  protected CustomSecuritySchema(
      SwaggerProperties.SecuritySchemaFlow flow) {
    this.flow = flow;
  }

  public SwaggerProperties.SecuritySchemaFlow getFlow() {
    return flow;
  }

  public abstract SecurityScheme build();
}
