/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core.dto;

import com.google.common.collect.ImmutableList;
import digital.nedra.commons.starter.security.engine.core.Fields;

public record AuthorityDto(String name, ImmutableList<RoleDto> roles) {
    public static AuthorityDtoBuilder builder() {
        return new AuthorityDtoBuilder();
    }

    public static class AuthorityDtoBuilder {
        private String name;
        private ImmutableList<RoleDto> roles;

        AuthorityDtoBuilder() {
        }

        public AuthorityDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AuthorityDtoBuilder roles(ImmutableList<RoleDto> roles) {
            this.roles = roles;
            return this;
        }

        public AuthorityDto build() {
            return new AuthorityDto(this.name, this.roles);
        }

        public String toString() {
            return "AuthorityDto.AuthorityDtoBuilder(name=" + this.name + ", roles=" + this.roles + ")";
        }
    }

    public record RoleDto(String name, boolean available, ImmutableList<String> fields, Fields.Type type) {
        public static RoleDtoBuilder builder() {
            return new RoleDtoBuilder();
        }

        public static class RoleDtoBuilder {
            private String name;
            private boolean available;
            private ImmutableList<String> fields;
            private Fields.Type type;

            RoleDtoBuilder() {
            }

            public RoleDtoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public RoleDtoBuilder available(boolean available) {
                this.available = available;
                return this;
            }

            public RoleDtoBuilder fields(ImmutableList<String> fields) {
                this.fields = fields;
                return this;
            }

            public RoleDtoBuilder type(Fields.Type type) {
                this.type = type;
                return this;
            }

            public RoleDto build() {
                return new RoleDto(this.name, this.available, this.fields, this.type);
            }

            public String toString() {
                return "AuthorityDto.RoleDto.RoleDtoBuilder(name=" + this.name + ", available=" + this.available + ", fields=" + this.fields + ", type=" + this.type + ")";
            }
        }
    }
}

