/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.utils;

import digital.nedra.commons.starter.security.engine.core.Authority;
import digital.nedra.commons.starter.security.engine.core.AuthorityContext;
import digital.nedra.commons.starter.security.engine.core.DefaultContext;
import digital.nedra.commons.starter.security.engine.core.RoleHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;

public final class SecurityUtils {
    public static final String OID = "oid";
    public static final String SUB = "sub";

    public static Optional<String> getUserOid() {
        Map<String, Object> claims = SecurityUtils.getClaims();
        String key = claims.containsKey(OID) ? OID : SUB;
        return SecurityUtils.getClaimValue(claims, key);
    }

    public static Optional<String> getClaimValue(String propertyName) {
        return SecurityUtils.getClaimValue(SecurityUtils.getClaims(), propertyName);
    }

    private static Optional<String> getClaimValue(Map<String, Object> claims, String propertyName) {
        return Optional.ofNullable(propertyName).map(claims::get).map(a -> (String)ClaimConversionService.getSharedInstance().convert(a, String.class));
    }

    public static Map<String, Set<String>> getRoleAuthorityMap(List<RoleHandler> handlers) {
        List<String> roles = handlers.stream().map(RoleHandler::getRole).distinct().toList();
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String role : roles) {
            Set auth = handlers.stream().filter(handler -> role.equalsIgnoreCase(handler.getRole())).map(RoleHandler::getAuthorities).flatMap(Collection::stream).map(Authority::getName).collect(Collectors.toSet());
            map.put(role, auth);
        }
        return map;
    }

    public static Set<String> getAllUsedAuthorities(List<RoleHandler> handlers) {
        return handlers.stream().map(RoleHandler::getAuthorities).flatMap(Collection::stream).map(Authority::getName).collect(Collectors.toSet());
    }

    public static Set<String> getAllRoles(List<RoleHandler> handlers) {
        Map<String, Set<String>> map = SecurityUtils.getRoleAuthorityMap(handlers);
        return map.keySet();
    }

    public static Set<String> getAllAuthorities(List<RoleHandler> handlers) {
        Map<String, Set<String>> map = SecurityUtils.getRoleAuthorityMap(handlers);
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static List<String> getRoleAuthorities(List<String> roles, List<RoleHandler> handlers) {
        return handlers.stream().filter(handler -> SecurityUtils.filterByRole(roles, handler)).map(SecurityUtils::getAuthorityList).flatMap(Collection::stream).distinct().toList();
    }

    public static AuthorityContext createDefaultContext(List<String> roles) {
        DefaultContext defaultContext = new DefaultContext();
        defaultContext.setRoles(roles);
        return defaultContext;
    }

    private static boolean filterByRole(List<String> roles, RoleHandler handler) {
        return Optional.ofNullable(handler.getRole()).map(r -> roles.stream().anyMatch(r::equalsIgnoreCase)).orElse(false);
    }

    private static List<String> getAuthorityList(RoleHandler handler) {
        return handler.getAuthorities().stream().filter(Authority::isAvailable).map(Authority::getName).toList();
    }

    private static Map<String, Object> getClaims() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::getPrincipal).filter(ClaimAccessor.class::isInstance).map(ClaimAccessor.class::cast).map(ClaimAccessor::getClaims).orElse(Map.of());
    }

    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

