/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core.dto;

import com.google.common.collect.ImmutableList;
import digital.nedra.commons.starter.security.engine.core.Fields;

public record RoleAuthoritiesDto(String role, ImmutableList<RoleAuthorityDto> authorities) {
    public static RoleAuthoritiesDtoBuilder builder() {
        return new RoleAuthoritiesDtoBuilder();
    }

    public static class RoleAuthoritiesDtoBuilder {
        private String role;
        private ImmutableList<RoleAuthorityDto> authorities;

        RoleAuthoritiesDtoBuilder() {
        }

        public RoleAuthoritiesDtoBuilder role(String role) {
            this.role = role;
            return this;
        }

        public RoleAuthoritiesDtoBuilder authorities(ImmutableList<RoleAuthorityDto> authorities) {
            this.authorities = authorities;
            return this;
        }

        public RoleAuthoritiesDto build() {
            return new RoleAuthoritiesDto(this.role, this.authorities);
        }

        public String toString() {
            return "RoleAuthoritiesDto.RoleAuthoritiesDtoBuilder(role=" + this.role + ", authorities=" + this.authorities + ")";
        }
    }

    public record RoleAuthorityDto(String name, boolean available, ImmutableList<String> fields, Fields.Type type) {
        public static RoleAuthorityDtoBuilder builder() {
            return new RoleAuthorityDtoBuilder();
        }

        public static class RoleAuthorityDtoBuilder {
            private String name;
            private boolean available;
            private ImmutableList<String> fields;
            private Fields.Type type;

            RoleAuthorityDtoBuilder() {
            }

            public RoleAuthorityDtoBuilder name(String name) {
                this.name = name;
                return this;
            }

            public RoleAuthorityDtoBuilder available(boolean available) {
                this.available = available;
                return this;
            }

            public RoleAuthorityDtoBuilder fields(ImmutableList<String> fields) {
                this.fields = fields;
                return this;
            }

            public RoleAuthorityDtoBuilder type(Fields.Type type) {
                this.type = type;
                return this;
            }

            public RoleAuthorityDto build() {
                return new RoleAuthorityDto(this.name, this.available, this.fields, this.type);
            }

            public String toString() {
                return "RoleAuthoritiesDto.RoleAuthorityDto.RoleAuthorityDtoBuilder(name=" + this.name + ", available=" + this.available + ", fields=" + this.fields + ", type=" + this.type + ")";
            }
        }
    }
}

