/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core;

import com.google.common.collect.ImmutableList;
import digital.nedra.commons.starter.security.engine.config.SecurityEngineProperties;
import digital.nedra.commons.starter.security.engine.core.AuthParam;
import digital.nedra.commons.starter.security.engine.core.Authority;
import digital.nedra.commons.starter.security.engine.core.AuthorityCheck;
import digital.nedra.commons.starter.security.engine.core.AuthorityContext;
import digital.nedra.commons.starter.security.engine.core.AuthorityContextPayload;
import digital.nedra.commons.starter.security.engine.core.AuthorityException;
import digital.nedra.commons.starter.security.engine.core.AuthorityWithContextHandler;
import digital.nedra.commons.starter.security.engine.core.ContextBuilder;
import digital.nedra.commons.starter.security.engine.core.DefaultContextPayload;
import digital.nedra.commons.starter.security.engine.core.Fields;
import digital.nedra.commons.starter.security.engine.core.RoleHandler;
import digital.nedra.commons.starter.security.engine.core.RoleResolver;
import digital.nedra.commons.starter.security.engine.core.dto.AuthorityDto;
import digital.nedra.commons.starter.security.engine.core.dto.RoleAuthoritiesDto;
import digital.nedra.commons.starter.security.engine.utils.SecurityUtils;
import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RestController;

@Component
public class SecurityEngine {
    private static final Logger log = LoggerFactory.getLogger(SecurityEngine.class);
    private final List<ContextBuilder<? extends AuthorityContext>> builders;
    private final List<RoleHandler> handlers;
    private final RoleResolver roleResolver;
    private final SecurityEngineProperties securityEngineProperties;
    private ImmutableList<AuthorityWithContextHandler> authorityWithContextHandlers;

    @PostConstruct
    public void init() {
        this.checkIfAuthorityAssignedToAllUsersRoles();
    }

    public void checkPermission(String authority, String description, Class<? extends ContextBuilder<AuthorityContext>> builder, AuthorityContextPayload payload) {
        AuthorityContext context;
        List<String> userRoles = this.roleResolver.getRoles();
        List<RoleHandler> authHandlers = this.getPermissionHandlers(authority, userRoles);
        boolean isNoPermissions = CollectionUtils.isEmpty(authHandlers);
        if (isNoPermissions) {
            this.throwAuthorityException(authority, description, userRoles);
        }
        if (!this.isAllowed(authority, authHandlers, context = this.createContext(builder, payload, userRoles))) {
            this.throwAuthorityException(authority, description, userRoles);
        }
    }

    public boolean hasPermission(String authority, Class<? extends ContextBuilder<AuthorityContext>> builder, AuthorityContextPayload payload) {
        List<String> userRoles = this.roleResolver.getRoles();
        List<RoleHandler> authHandlers = this.getPermissionHandlers(authority, userRoles);
        if (CollectionUtils.isEmpty(authHandlers)) {
            return false;
        }
        AuthorityContext context = this.createContext(builder, payload, userRoles);
        return this.isAllowed(authority, authHandlers, context);
    }

    public boolean isCalledFromRestController() {
        String packageRegExFilter = this.securityEngineProperties.getRestControllerPackageFilter();
        Pattern packagePattern = Pattern.compile(packageRegExFilter);
        return Stream.of(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).filter(packagePattern.asMatchPredicate()).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }).filter(Objects::nonNull).anyMatch(clazz -> Objects.nonNull(clazz.getAnnotation(RestController.class)) || Objects.nonNull(clazz.getAnnotation(Controller.class)));
    }

    public Set<String> getAllRoles() {
        return SecurityUtils.getAllRoles(this.handlers);
    }

    public List<String> getAllPermissions() {
        return SecurityUtils.getAllAuthorities(this.handlers).stream().sorted().collect(Collectors.toList());
    }

    public List<String> getRolePermissions() {
        return SecurityUtils.getRoleAuthorities(this.roleResolver.getRoles(), this.handlers).stream().sorted().collect(Collectors.toList());
    }

    public List<RoleAuthoritiesDto> getAllRoleAuthorities() {
        return this.handlers.stream().map(handler -> {
            List authoritiesList = handler.getAuthorities().stream().map(this::newRoleAuthorityDto).collect(Collectors.toList());
            return RoleAuthoritiesDto.builder().role(handler.getRole()).authorities((ImmutableList<RoleAuthoritiesDto.RoleAuthorityDto>)ImmutableList.copyOf(authoritiesList)).build();
        }).collect(Collectors.toList());
    }

    public List<AuthorityDto> getAllAuthoritiesAndRoles() {
        Set<String> allAuthorities = SecurityUtils.getAllAuthorities(this.handlers);
        return allAuthorities.stream().distinct().map(this::newAuthorities).collect(Collectors.toList());
    }

    public void initAuthorityHandlerList(ApplicationContext applicationContext) throws BeansException {
        List authorityHandlerList = Stream.of(applicationContext.getBeanDefinitionNames()).filter(Predicate.not("securityEngineInitializer"::equals)).map(arg_0 -> ((ApplicationContext)applicationContext).getBean(arg_0)).map(this::findMethodsWithAuthorityCheckAnnotation).flatMap(Collection::stream).map(this::createAuthorityHandlerItem).filter(Objects::nonNull).collect(Collectors.toList());
        this.authorityWithContextHandlers = ImmutableList.copyOf(authorityHandlerList);
    }

    public List<String> calculateUserAuthoritiesForContextParameters(@Nullable Map<String, Object> parameters) {
        Objects.requireNonNull(this.authorityWithContextHandlers);
        List<String> availableAuthorities = this.getRolePermissions();
        List authoritiesWithHandlers = this.authorityWithContextHandlers.stream().filter(authority -> availableAuthorities.contains(authority.getName())).collect(Collectors.toList());
        List forbiddenAuthorities = authoritiesWithHandlers.stream().filter(authority -> !this.isCurrentUserHasPermissionForAuthority(parameters, (AuthorityWithContextHandler)authority)).map(AuthorityWithContextHandler::getName).distinct().collect(Collectors.toList());
        availableAuthorities.removeAll(forbiddenAuthorities);
        return availableAuthorities;
    }

    private AuthorityContext createContext(Class<? extends ContextBuilder<AuthorityContext>> builder, AuthorityContextPayload payload, List<String> userRoles) {
        if (this.isBuilderNotSet(builder)) {
            return SecurityUtils.createDefaultContext(userRoles);
        }
        return this.builders.stream().filter(builder::isInstance).map(builder::cast).map(authBuilder -> authBuilder.build(userRoles, payload)).findFirst().orElseGet(() -> SecurityUtils.createDefaultContext(userRoles));
    }

    private boolean isBuilderNotSet(Class<? extends ContextBuilder<AuthorityContext>> builder) {
        return ContextBuilder.class.equals(builder);
    }

    private List<RoleHandler> getPermissionHandlers(String authority, List<String> userRoles) {
        return this.handlers.stream().filter(handler -> this.hasRole(userRoles, (RoleHandler)handler) && this.includeAuthority(authority, (RoleHandler)handler)).collect(Collectors.toList());
    }

    private boolean isAllowed(String authority, List<RoleHandler> authHandlers, AuthorityContext context) {
        return authHandlers.stream().anyMatch(handler -> handler.handle(authority, context));
    }

    private void throwAuthorityException(String authority, String description, List<String> userRoles) {
        String message = String.format("\u041d\u0435\u0442 authority [%s] \u0443 \u0440\u043e\u043b\u0438 [%s] \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a api %s.", authority, userRoles, description);
        throw new AuthorityException(message);
    }

    private boolean hasRole(List<String> roles, RoleHandler handler) {
        return Optional.ofNullable(handler.getRole()).map(r -> roles.stream().anyMatch(r::equalsIgnoreCase)).orElse(false);
    }

    private boolean includeAuthority(String authority, RoleHandler handler) {
        return handler.getAuthorities().stream().map(Authority::getName).anyMatch(authority::equalsIgnoreCase);
    }

    private void checkIfAuthorityAssignedToAllUsersRoles() {
        Map<String, Set<String>> authoritiesByRole = SecurityUtils.getRoleAuthorityMap(this.handlers);
        Set<String> allUsedAuthorities = SecurityUtils.getAllUsedAuthorities(this.handlers);
        SecurityEngineProperties.StartMode startMode = this.securityEngineProperties.getStartMode();
        authoritiesByRole.entrySet().stream().filter(e -> ((Set)e.getValue()).size() < allUsedAuthorities.size()).forEach(e -> {
            String name = (String)e.getKey();
            Set roleAuths = (Set)e.getValue();
            HashSet a = new HashSet(allUsedAuthorities);
            a.removeAll(roleAuths);
            String authRep = String.join((CharSequence)",", a);
            String message = String.format("\u0414\u043b\u044f \u0440\u043e\u043b\u0438 [%s] \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043f\u0440\u0430\u0432\u0430 \u043d\u0430 [%s].", name, authRep);
            switch (startMode) {
                case STRICT: {
                    throw new AuthorityException(String.format("Can't start security engine. %s", message));
                }
                case RELAXED: {
                    log.warn(message);
                    break;
                }
                default: {
                    log.warn("Security engine start mode=[{}] is not supported", (Object)startMode);
                }
            }
        });
    }

    private RoleAuthoritiesDto.RoleAuthorityDto newRoleAuthorityDto(Authority auth) {
        Optional<Fields> fields = Optional.ofNullable(auth.getContext());
        return RoleAuthoritiesDto.RoleAuthorityDto.builder().name(auth.getName()).fields((ImmutableList<String>)((ImmutableList)fields.map(Fields::getValue).orElse(null))).available(auth.isAvailable()).type(fields.map(Fields::getType).orElse(null)).build();
    }

    private AuthorityDto newAuthorities(String authority) {
        List listOfRoles = this.handlers.stream().map(handler -> handler.getAuthorities().stream().filter(auth -> authority.equalsIgnoreCase(auth.getName())).findFirst().map(auth -> this.newRole((RoleHandler)handler, (Authority)auth)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        return AuthorityDto.builder().name(authority).roles((ImmutableList<AuthorityDto.RoleDto>)ImmutableList.copyOf(listOfRoles)).build();
    }

    private AuthorityDto.RoleDto newRole(RoleHandler handler, Authority authority) {
        Optional<Fields> fields = Optional.ofNullable(authority.getContext());
        return AuthorityDto.RoleDto.builder().name(handler.getRole()).available(authority.isAvailable()).fields((ImmutableList<String>)((ImmutableList)fields.map(Fields::getValue).orElse(null))).type(fields.map(Fields::getType).orElse(null)).build();
    }

    private boolean isCurrentUserHasPermissionForAuthority(Map<String, Object> parameters, AuthorityWithContextHandler authority) {
        DefaultContextPayload defaultContextPayload = new DefaultContextPayload();
        if (Objects.nonNull(parameters)) {
            parameters.entrySet().forEach(entry -> defaultContextPayload.set((String)entry.getKey(), entry.getValue()));
        }
        Class<? extends ContextBuilder> clazz = authority.getContextBuilder();
        return this.hasPermission(authority.getName(), clazz, defaultContextPayload);
    }

    private List<Method> findMethodsWithAuthorityCheckAnnotation(Object bean) {
        Class<?> clazz = bean.getClass();
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return Collections.emptyList();
        }
        Method[] methods = superClazz.getDeclaredMethods();
        return Stream.of(methods).filter(method -> {
            AuthorityCheck authorityCheck = method.getAnnotation(AuthorityCheck.class);
            return authorityCheck != null && !ContextBuilder.class.equals(authorityCheck.handler());
        }).collect(Collectors.toList());
    }

    private AuthorityWithContextHandler createAuthorityHandlerItem(Method method) {
        AuthorityCheck annotation = method.getAnnotation(AuthorityCheck.class);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        List authParamAnnotations = Stream.of(parameterAnnotations).flatMap(Stream::of).filter(parameterAnnotation -> AuthParam.class.equals(parameterAnnotation.annotationType())).map(AuthParam.class::cast).map(AuthParam::value).filter(Objects::nonNull).collect(Collectors.toList());
        return AuthorityWithContextHandler.builder().contextBuilder(annotation.handler()).name(annotation.value()).parameters((ImmutableList<String>)ImmutableList.copyOf(authParamAnnotations)).build();
    }

    public SecurityEngine(List<ContextBuilder<? extends AuthorityContext>> builders, List<RoleHandler> handlers, RoleResolver roleResolver, SecurityEngineProperties securityEngineProperties) {
        this.builders = builders;
        this.handlers = handlers;
        this.roleResolver = roleResolver;
        this.securityEngineProperties = securityEngineProperties;
    }
}

