/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core;

import digital.nedra.commons.starter.security.engine.core.AuthParam;
import digital.nedra.commons.starter.security.engine.core.AuthorityCheck;
import digital.nedra.commons.starter.security.engine.core.AuthorityContextPayload;
import digital.nedra.commons.starter.security.engine.core.ContextBuilder;
import digital.nedra.commons.starter.security.engine.core.DefaultContextPayload;
import digital.nedra.commons.starter.security.engine.core.SecurityEngine;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AuthorityHandlerAspect {
    private final SecurityEngine securityEngine;

    @Pointcut(value="@annotation(digital.nedra.commons.starter.security.engine.core.AuthorityCheck)")
    public void annotatedAuthorityPointcut() {
    }

    @Around(value="annotatedAuthorityPointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.securityEngine.isCalledFromRestController()) {
            this.extractAnnotation(joinPoint).ifPresent(authorityCheck -> this.checkPermission(joinPoint, authorityCheck.handler(), authorityCheck.value(), authorityCheck.description()));
        }
        return joinPoint.proceed();
    }

    private void checkPermission(ProceedingJoinPoint joinPoint, Class<? extends ContextBuilder> builder, String authority, String errorMessage) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        AuthorityContextPayload payload = this.getAuthorityContextPayload(joinPoint.getArgs(), signature.getMethod().getParameterAnnotations());
        this.securityEngine.checkPermission(authority, errorMessage, builder, payload);
    }

    private Optional<AuthorityCheck> extractAnnotation(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        return Stream.of(method.getDeclaredAnnotations()).filter(annotation -> AuthorityCheck.class.equals(annotation.annotationType())).map(AuthorityCheck.class::cast).findFirst();
    }

    private AuthorityContextPayload getAuthorityContextPayload(Object[] args, Annotation[][] annotations) {
        DefaultContextPayload payload = new DefaultContextPayload();
        for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                Class<? extends Annotation> clazz = annotation.annotationType();
                if (!AuthParam.class.equals(clazz)) continue;
                String name = ((AuthParam)annotation).value();
                payload.set(name, args[i]);
            }
        }
        return payload;
    }

    public AuthorityHandlerAspect(SecurityEngine securityEngine) {
        this.securityEngine = securityEngine;
    }
}

