/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.engine.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Getter;

public class DefaultContextPayload implements AuthorityContextPayload {

  @Getter
  private final Map<String, Object> params = new HashMap<>();

  @Override
  public void set(final String key, final Object value) {
    params.put(key, value);
  }

  @Override
  public Object getByName(final String name) {
    return params.get(name);
  }

  @Override
  public <T> Optional<T> getByType(final Class<T> type) {
    return params.values()
        .stream()
        .filter(type::isInstance)
        .map(type::cast)
        .findFirst();
  }

}
